% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fingertips_data.R
\name{fingertips_data}
\alias{fingertips_data}
\title{Fingertips data}
\usage{
fingertips_data(
  IndicatorID = NULL,
  AreaCode = NULL,
  DomainID = NULL,
  ProfileID = NULL,
  AreaTypeID,
  ParentAreaTypeID = NULL,
  categorytype = FALSE,
  rank = FALSE,
  path
)
}
\arguments{
\item{IndicatorID}{Numeric vector, id of the indicator of interest}

\item{AreaCode}{Character vector, ONS area code of area of interest}

\item{DomainID}{Numeric vector, id of domains of interest}

\item{ProfileID}{Numeric vector, id of profiles of interest. Indicator
polarity can vary between profiles therefore if using one of the comparison
fields it is recommended to complete this field as well as IndicatorID. If
IndicatorID is populated, ProfileID can be ignored or must be the same
length as IndicatorID (but can contain NAs).}

\item{AreaTypeID}{Numeric vector, the Fingertips ID for the area type. This
argument accepts "All", which returns data for all available area
types for the indicator(s), though this can take a long time to run}

\item{ParentAreaTypeID}{Numeric vector, the comparator area type for the data
extracted; if NULL the function will use the first record for the specified
`AreaTypeID` from the area_types() function}

\item{categorytype}{TRUE or FALSE, determines whether the final table
includes categorytype data where it exists. Default to FALSE}

\item{rank}{TRUE or FALSE, the rank of the area compared to other areas for
that combination of indicator, sex, age, categorytype and category along
with the indicator's polarity. 1 is lowest NAs will be bottom and ties will
return the average position. The total count of areas with a non-NA value
are returned also in AreaValuesCount}

\item{path}{String; Fingertips API address. Function will default to the
correct address}
}
\value{
A data frame of data extracted from the Fingertips API
}
\description{
Outputs a data frame of data from
\href{https://fingertips.phe.org.uk/}{Fingertips}. Note, this function can
take up to a few minutes to run (depending on internet connection speeds and
parameter selection).
}
\details{
Note, polarity of an indicator is not automatically returned (eg,
  whether a low value is good, bad or neither). Use the rank field for this
  to be returned (though it adds a lot of time to the query)
}
\examples{
\dontrun{
# Returns data for the two selected domains at county and unitary authority geography
doms <- c(1000049,1938132983)
fingdata <- fingertips_data(DomainID = doms, AreaTypeID = 202)

# Returns data at local authority district geography (AreaTypeID = 101)
# for the indicator with the id 22401
fingdata <- fingertips_data(22401, AreaTypeID = 101)

# Returns same indicator with different comparisons due to indicator polarity
# differences between profiles on the website
# It is recommended to check the website to ensure consistency between your
# data extract here and the polarity required
fingdata <- fingertips_data(rep(90282,2),
                            ProfileID = c(19,93),
                            AreaTypeID = 202,
                            AreaCode = "E06000008")
fingdata <- fingdata[order(fingdata$TimeperiodSortable, fingdata$Sex),]

# Returns data for all available area types for an indicator
fingdata <- fingertips_data(10101, AreaTypeID = "All")}
}
\seealso{
Other data extract functions: 
\code{\link{fingertips_redred}()}
}
\concept{data extract functions}
