% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finbif_occurrence_load.R
\name{finbif_occurrence_load}
\alias{finbif_occurrence_load}
\alias{fb_occurrence_load}
\title{Load FinBIF occurrence records from a file}
\usage{
finbif_occurrence_load(
  file,
  select,
  n,
  count_only = FALSE,
  quiet = FALSE,
  cache = getOption("finbif_use_cache"),
  dwc = FALSE,
  date_time_method,
  tzone = getOption("finbif_tz"),
  locale = getOption("finbif_locale"),
  write_file = tempfile()
)
}
\arguments{
\item{file}{Character or Integer. Either the path to a Zip archive or a TSV
data file that has been downloaded from "laji.fi". Or a URI pointing to the
data file (e.g., \url{http://tun.fi/HBF.49381}) or the
integer representing the URI (i.e., \code{49381}).}

\item{select}{Character vector. Variables to return. If not specified a
default set of commonly used variables will be used. Use \code{"default_vars"}
as a shortcut for this set. Variables can be deselected by prepending a \code{-}
to the variable name. If only deselects are specified the default set of
variables without the deselection will be returned.}

\item{n}{Integer. How many records to download/import.}

\item{count_only}{Logical. Only return the number of records available.}

\item{quiet}{Logical. Suppress the progress indicator for multipage
downloads.}

\item{cache}{Logical. Use cached data.}

\item{dwc}{Logical. Use Darwin Core (or Darwin Core style) variable names.}

\item{date_time_method}{Character. Passed to \code{lutz::tz_lookup_coords()} when
\code{date_time} and/or \code{duration} variables have been selected. Default is
\code{"fast"} when  less than 100,000 records are requested and \code{"none"} when
more. Using method \code{"none"} assumes all records are in timezone
"Europe/Helsinki", Use \code{date_time_method = "accurate"} (requires package
\code{sf}) for greater accuracy at the cost of slower computation.}

\item{tzone}{Character. If \code{date_time} has been selected the timezone of the
outputted date-time. Defaults to system timezone.}

\item{locale}{Character. One of the supported two-letter ISO 639-1 language
codes. Current supported languages are English, Finnish, Swedish, Russian,
and Sámi (Northern). For data where more than one language is available
the language denoted by \code{locale} will be preferred while falling back to
the other languages in the order indicated above.}

\item{write_file}{Character. Path to write downloaded zip file to if \code{file}
refers to a URI. Will be ignored if \code{getOption("finbif_cache_path")} is not
\code{NULL}.}
}
\value{
A \code{data.frame}, or if \code{count_only =  TRUE} an integer.
}
\description{
Load occurrence data from a file as a \code{data.frame}.
}
\examples{
\dontrun{

# Get occurrence data
finbif_occurrence_load(49381)

}
}
