% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{finland_map}
\alias{finland_map}
\title{Border of Finland}
\format{A list:
\describe{
\item{vertices}{A matrix of the vertices, in decimal degrees (WGS84) of the
Finnish border at the (approximately) 1km scale.}
\item{bbox}{A vector of coordinates for a box bounding the Finnish border.}
...
}}
\source{
\url{https://www.stat.fi/org/avoindata/paikkatietoaineistot.html}
}
\usage{
finland_map
}
\description{
Vertices of the Finnish border at the (approximately) 1km scale.
}
\examples{
library(finbif)
with(
  finland_map,
  {plot.new()
   plot.window(
     bbox[c(1, 3)],
     bbox[c(2, 4)],
     asp = 2.4
   )
   polygon(vertices)}
)
}
\keyword{datasets}
