% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_newdata.R
\name{summary_df}
\alias{summary_df}
\title{Summarise with mode for factors and mean/median for numeric variables}
\usage{
summary_df(.data, cont = "mean")
}
\arguments{
\item{.data}{A data frame or tibble.}

\item{cont}{One of "mean" or "median": the summary estimate for continuous variables.}
}
\value{
A data frame or tibble with the mode for factors and mean/median 
for continuous variables.
}
\description{
When producing conditional estimates from a regression model, it is often useful
to set variables not of interest to their mode for factors and mean or median for numerics
when creating the newdata object.
}
\examples{
library(dplyr)
colon_s \%>\% 
  select(age, sex.factor, obstruct.factor, perfor.factor) \%>\% 
  summary_df()
  
  colon_s \%>\% 
    select(age, sex.factor, obstruct.factor, perfor.factor) \%>\% 
    summary_df(cont = "median")
}
\seealso{
\code{\link{ff_mode}} \code{\link{ff_expand}}
}
