% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{extract_numbers}
\alias{extract_numbers}
\alias{extract_non_numerics}
\alias{nth_number}
\alias{nth_non_numeric}
\title{Extract numbers (or non-numbers) from a string.}
\usage{
extract_numbers(string, leave_as_string = FALSE, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE)

extract_non_numerics(string, decimals = FALSE, leading_decimals = FALSE,
  negs = FALSE)

nth_number(string, n = 1, leave_as_string = FALSE, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE)

nth_non_numeric(string, n = 1, decimals = FALSE, leading_decimals = FALSE,
  negs = FALSE)
}
\arguments{
\item{string}{A string.}

\item{leave_as_string}{Do you want to return the number as a string (\code{TRUE})
or as numeric (\code{FALSE}, the default)?}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{n}{The index of the number (or non-numeric) that you seek. Negative
indexing is allowed i.e. \code{n = 1} (the default) will give you the first
number (or non-numeric) whereas \code{n = -1} will give you the last number (or
non-numeric), \code{n = -2} will give you the second last number and so on.}
}
\value{
For \code{extract_numbers} and \code{extract_non_numerics}, a list of numeric or
character vectors, one list element for each element of \code{string}. For
\code{nth_number} and \code{nth_non_numeric}, a vector the same length as \code{string} (as
in \code{length(string)}, not \code{nchar(string)}).
}
\description{
\code{extract_numbers} extracts the numbers (or non-numbers) from a string where
decimals are optionally allowed. \code{extract_non_numerics} extracts the bits of
the string that aren't extracted by \code{extract_numbers}. \code{nth_number} is a
convenient wrapper for \code{extract_numbers}, allowing you to choose which number
you want. Similarly \code{nth_non_numeric}. Please view the examples at the bottom
of this page to ensure that you understand how these functions work, and
their limitations. These functions are vectorised over \code{string}.
}
\details{
If any part of a string contains an ambiguous number (e.g. \code{1.2.3} would be
ambiguous if \code{decimals = TRUE} (but not otherwise)), the value returned for
that string will be \code{NA}. Note that these functions do not know about
scientific notation (e.g. \code{1e6} for 1000000).
}
\examples{
extract_numbers(c("abc123abc456", "abc1.23abc456"))
extract_numbers(c("abc1.23abc456", "abc1..23abc456"), decimals = TRUE)
extract_numbers("abc1..23abc456", decimals = TRUE)
extract_numbers("abc1..23abc456", decimals = TRUE, leading_decimals = TRUE)
extract_numbers("abc1..23abc456", decimals = TRUE, leading_decimals = TRUE,
                leave_as_string = TRUE)
extract_numbers("-123abc456")
extract_numbers("-123abc456", negs = TRUE)
extract_numbers("--123abc456", negs = TRUE)
extract_non_numerics("abc123abc456")
extract_non_numerics("abc1.23abc456")
extract_non_numerics("abc1.23abc456", decimals = TRUE)
extract_non_numerics("abc1..23abc456", decimals = TRUE)
extract_non_numerics("abc1..23abc456", decimals = TRUE,
leading_decimals = TRUE)
extract_non_numerics(c("-123abc456", "ab1c"))
extract_non_numerics("-123abc456", negs = TRUE)
extract_non_numerics("--123abc456", negs = TRUE)
extract_numbers(c(rep("abc1.2.3", 2), "a1b2.2.3", "e5r6"), decimals = TRUE)
extract_numbers("ab.1.2", decimals = TRUE, leading_decimals = TRUE)
nth_number("abc1.23abc456", 2)
nth_number("abc1.23abc456", 2, decimals = TRUE)
nth_number("-123abc456", -2, negs = TRUE)
extract_non_numerics("--123abc456", negs = TRUE)
nth_non_numeric("--123abc456", 1)
nth_non_numeric("--123abc456", -2)
}
