% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncyc2meco.R
\name{ncyc2meco}
\alias{ncyc2meco}
\title{Transform 'Ncyc' metagenomic abundance to 'microtable' object.}
\usage{
ncyc2meco(abund_table, sample_data = NULL, match_table = NULL)
}
\arguments{
\item{abund_table}{'Ncyc' software output abundance table, see the example file.}

\item{sample_data}{default NULL; the sample metadata table, must be tab or comma seperated file, generally, a file with suffix "tsv" or "csv"..}

\item{match_table}{default NULL; a two column table used to replace the sample names in HUMAnN abundance result; Remember just two columns with no column names;
The first column must be sample names used in abund_table, the second column is the new sample names, e.g. the rownames in sample_table. See the example files.}
}
\value{
microtable object.
}
\description{
Transform 'Ncyc' metagenomic abundance to microtable object. Reference: Qichao et al. (2019) <doi: 10.1093/bioinformatics/bty741>.
}
\examples{
\donttest{
# use the raw data files stored inside the package
abund_file_path <- system.file("extdata", "example_Ncyc_table.tsv", package="file2meco")
sample_file_path <- system.file("extdata", "example_metagenome_sample_info.tsv", 
  package="file2meco")
match_file_path <- system.file("extdata", "example_metagenome_match_table.tsv", package="file2meco")
library(microeco)
library(file2meco)
library(magrittr)
ncyc2meco(abund_table = abund_file_path)
test <- ncyc2meco(abund_table = abund_file_path, sample_data = sample_file_path, 
  match_table = match_file_path)
test$tidy_dataset()
# use split_group = TRUE to calculate the pathway abundance with multipe map correspondance
test$cal_abund(select_cols = 1:2, rel = TRUE, split_group = TRUE, split_column = "Pathway")
test$taxa_abund$Pathway \%<>\% .[!grepl("unclass", rownames(.)), ]
test1 <- trans_abund$new(test, taxrank = "Pathway")
test1$plot_bar(bar_type = "notfull")
# for gene abundance, no splitting on the Pathway
test$cal_abund(select_cols = 1:2, rel = TRUE, split_group = FALSE)
test$taxa_abund$Gene \%<>\% .[!grepl("unclass", rownames(.)), ]
test1 <- trans_abund$new(test, taxrank = "Gene")
test1$plot_bar(bar_type = "notfull")
}
}
