% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geCheck.R
\name{geCheck}
\alias{geCheck}
\title{geCheck}
\usage{
geCheck(x)
}
\arguments{
\item{x}{An object of class \emph{SpatialPolygons} or \emph{SpatialPolygonsDataFrame}.}
}
\value{
A \emph{list}.
}
\description{
Finds overlaps between polygons in the same shapefile.
}
\details{
{compares all elements of \emph{x} and returns a a list containing:
\itemize{
 \item{\emph{overlap.df} - \emph{data.frame} where each row shows the indices of which two polygons overlap.}
 \item{\emph{overlap.shp} - \emph{SpatialPointsDataFrame} with the actual overlap for each row in \emph{overlap.df}.}}}
}
\examples{
{

require(raster)

# build polygons
df1 <- data.frame(x=c(1, 5, 10, 2, 1), y=c(10, 9, 8, 7, 10))
df2 <- data.frame(x=c(2, 6, 5, 4, 2), y=c(10, 9, 7, 4, 10))
p <- list(Polygons(list(Polygon(df1)), ID=1), 
Polygons(list(Polygon(df2)), ID=2))
p <- SpatialPolygons(p)

# check overlap
co <- geCheck(p)

# show distance matrix
plot(p)
plot(co$overlap.shp, col="red", add=TRUE)

}
}
\seealso{
\code{\link{spCentroid}} \code{\link{ecDistance}}
}
