% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhir_table_description.R
\name{fhir_table_description}
\alias{fhir_table_description}
\title{Create \linkS4class{fhir_table_description} object}
\usage{
fhir_table_description(resource, cols = fhir_columns(), style = fhir_style())
}
\arguments{
\item{resource}{A character vector of length one or \linkS4class{fhir_resource_type} object
indicating which resource type should be extracted.}

\item{cols}{Optional. A \linkS4class{fhir_columns} object or something that can be coerced to one,
like a (named) character vector, a (named) list containing xpath expressions,
or a \linkS4class{fhir_xpath_expression} object. See \code{\link[=fhir_columns]{fhir_columns()}} and the examples.
If this argument is omitted, an empty \linkS4class{fhir_columns} object will be supplied.
This means that in the call to \code{\link[=fhir_crack]{fhir_crack()}}, all available elements are extracted in put
in automatically named columns.}

\item{style}{Optional. A \linkS4class{fhir_style} object, as created by \code{\link[=fhir_style]{fhir_style()}}.
If this argument is omitted, default values will be assumed, see \code{\link[=fhir_style]{fhir_style()}}.}
}
\value{
An object of class \linkS4class{fhir_table_description}.
}
\description{
A \code{fhir_table_description} is part of a \code{fhir_design} and holds the information \code{\link[=fhir_crack]{fhir_crack()}} needs to flatten (aka crack)
FHIR resources from a FHIR bundle. There should be one \code{fhir_table_description} per resource type as
\code{\link[=fhir_crack]{fhir_crack()}} will create one data.frame/data.table per resource type. See Details.
}
\details{
A \code{fhir_table_description} consists of
the following elements:
\itemize{
\item The resource element: Defines the resource type (e.g. \code{Patient} or \code{Observation}). See \code{?fhir_resource}.
\item The cols element: Contains the column names and XPath expressions defining the columns to extract.
If this element is empty, \code{\link[=fhir_crack]{fhir_crack()}} will extract all available elements of the resource and name the
columns automatically. See \code{?fhir_columns}.
\item The style element: Defines how to deal with multiple entries to the same element and whether empty columns are
removed. See \code{?fhir_style}
}

A full \code{fhir_table_description} looks for example like this:\preformatted{fhir_resource_type: Patient

fhir_columns:
column name | xpath expression
------------------------
name        | name/family
gender      | gender
id          | id

fhir_style:
sep: ||
brackets: '[' ']'
rm_empty_cols: FALSE
}
}
\examples{
#named character for cols
fhir_table_description(resource = "Patient",
                       cols = c(name = "name/family",
                                gender = "gender",
                                id = "id"),
                       style = fhir_style(sep = "||",
                                          brackets = c("[", "]"),
                                          rm_empty_cols = FALSE)
)

#If style is ommitted, default values are assumed
fhir_table_description(resource = "Patient",
                       cols = c(name = "name/family",
                                gender = "gender",
                                id = "id")
)

#named list for cols
fhir_table_description(resource = "Patient",
                       cols = list(name = "name/family",
                                   gender = "gender",
                                   id = "id")
)

#unnamed character for cols, colnames are generated automatically
fhir_table_description(resource = "Patient",
                       cols = c("name/family",
                                "gender",
                                "id")
)
}
