% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.tt_df}
\alias{summary.tt_df}
\alias{summary.tt_lst}
\title{Summary of \code{tt_test()} results.}
\usage{
\method{summary}{tt_df}(object, ...)

\method{summary}{tt_lst}(object, ...)
}
\arguments{
\item{object}{An object of class "tt_df" or "tt_lst".}

\item{...}{Not used (included only for compatibility with \code{summary}).}
}
\value{
A tibble.
}
\description{
Summary of \code{tt_test()} results.
}
\examples{
assert_is_installed("fgeo.x")

tt_result <- tt_test(fgeo.x::tree6_3species, fgeo.x::habitat)

summary(tt_result)

# Same
summary(as_tibble(tt_result))

# You may want to add the explanation to the result of `tt_test()`

dplyr::left_join(as_tibble(tt_result), summary(tt_result))

# You may prefer a wide matrix
Reduce(rbind, tt_result)

# You may prefer a wide dataframe
tidyr::spread(summary(tt_result), "habitat", "association")
}
\seealso{
\code{\link[=tt_test]{tt_test()}}, \code{\link[base:summary]{base::summary()}}.
}
\author{
Adapted from code contributed by Daniel Zuleta.
}
\concept{methods for common generics}
