% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sleeper.R
\name{sleeper_connect}
\alias{sleeper_connect}
\title{Connect to Sleeper League}
\usage{
sleeper_connect(
  season = NULL,
  league_id = NULL,
  user_name = NULL,
  user_agent = NULL,
  rate_limit = TRUE,
  rate_limit_number = 100,
  rate_limit_seconds = 60
)
}
\arguments{
\item{season}{Season to access on Sleeper - if missing, will guess based on system date (current year if March or later, otherwise previous year)}

\item{league_id}{League ID (currently assuming one league at a time)}

\item{user_name}{Sleeper user_name - optional - attempts to get user's user ID}

\item{user_agent}{User agent to self-identify (optional)}

\item{rate_limit}{TRUE by default - turn off rate limiting with FALSE}

\item{rate_limit_number}{number of calls per \code{rate_limit_seconds}, suggested is 100 calls per 60 seconds}

\item{rate_limit_seconds}{number of seconds as denominator for rate_limit}
}
\value{
a list that stores MFL connection objects
}
\description{
This function creates a connection object which stores parameters and a user ID if available.
}
