% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-lmom-diagram.R
\name{plot_lmom_diagram}
\alias{plot_lmom_diagram}
\title{Plot L-Moment Ratio Diagram}
\usage{
plot_lmom_diagram(results, ...)
}
\arguments{
\item{results}{List of distribution selection results generated by \code{\link[=select_ldistance]{select_ldistance()}},
\code{\link[=select_lkurtosis]{select_lkurtosis()}}, or \code{\link[=select_zstatistic]{select_zstatistic()}}.}

\item{...}{Optional named arguments: 'title', 'xlabel', and 'ylabel'.}
}
\value{
\code{ggplot}; plot object containing the L-moment ratio diagram, with:
\itemize{
\item L-moment ratio curves for each 3-parameter distribution.
\item Points for the L-moment ratios of each 2-parameter distribution.
\item Sample and log-sample L-moment ratio \eqn{(t_3, t_4)} points.
}
}
\description{
Generates a plot of L-moment ratios with the L-skewness on the x-axis and L-kurtosis
on the y-axis. Plots the sample and log-sample L-moment ratios alongside the
theoretical L-moment ratios for a set of candidate distributions. Also includes
a small inset around the L-moment ratios of the recommended distribution.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
results <- select_ldistance(data)
plot_lmom_diagram(results)

}
\seealso{
\code{\link[=select_ldistance]{select_ldistance()}}, \code{\link[=select_lkurtosis]{select_lkurtosis()}}, \code{\link[=select_zstatistic]{select_zstatistic()}}
}
