% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eda-runs-test.R
\name{eda_runs_test}
\alias{eda_runs_test}
\title{Wald–Wolfowitz Runs Test for Randomness}
\usage{
eda_runs_test(values, years, alpha = 0.05)
}
\arguments{
\item{values}{A numeric vector of values to check for randomness.}

\item{years}{Numeric vector of observation years corresponding to \code{data}.
Must be the same length as \code{data} and strictly increasing.}

\item{alpha}{Numeric scalar in \eqn{[0.01, 0.1]}. The significance
level for confidence intervals or hypothesis tests. Default is 0.05.}
}
\value{
A list containing the test results, including:
\itemize{
\item \code{values}: The \code{values} argument.
\item \code{years}: The \code{years} argument.
\item \code{alpha}: The significance level as specified in the \code{alpha} argument.
\item \code{null_hypothesis}: A string describing the null hypothesis.
\item \code{alternative_hypothesis}: A string describing the alternative hypothesis.
\item \code{n}: The length of the input vector after removing the median.
\item \code{runs}: The number of runs in the transformed sequence of residuals.
\item \code{statistic}: The runs test statistic, computed using \code{runs} and \code{n}.
\item \code{p_value}: The p-value derived from the normally distributed test statistic.
\item \code{reject}: If \code{TRUE}, the null hypothesis was rejected at significance \code{alpha}.
}
}
\description{
Applies the Wald–Wolfowitz runs test to a numeric vector in order to assess
whether it behaves as a random sequence. The test statistic and p-value
is computed using the number of runs (sequences of values above or below the
median). Under the null hypothesis, the data is random. The runs test can be
used to assess whether the residuals of a nonstationary model are random,
indicating the suitability of the assumed nonstationary structure (e.g., linear).
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
years <- seq(from = 1901, to = 2000)
sens_trend <- eda_sens_trend(data, years)
eda_runs_test(sens_trend$residuals, years)

}
\references{
Wald, A. and Wolfowitz, J. (1940). On a test whether two samples are from the
same population. Annals of Mathematical Statistics, 11(2), 147–162.
}
\seealso{
\code{\link[=plot_runs_test]{plot_runs_test()}}, \code{\link[=eda_sens_trend]{eda_sens_trend()}}
}
