% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_strings.R
\name{clean_strings}
\alias{clean_strings}
\title{String cleaning for easier matching}
\usage{
clean_strings(
  string,
  sp_char_words = fedmatch::sp_char_words,
  common_words = NULL,
  remove_char = NULL,
  remove_words = FALSE,
  stem = FALSE
)
}
\arguments{
\item{string}{character or character vector of strings}

\item{sp_char_words}{character vector. Data.frame where first column is special characters and second column is full words. The default is}

\item{common_words}{data.frame. Data.frame where first column is abbreviations and second column is full words.}

\item{remove_char}{character vector. string of specific characters (for example, "letters") to be removed}

\item{remove_words}{logical. If TRUE, removes all abbreviations and replacement words in common_words}

\item{stem}{logical. If TRUE, words are stemmed}
}
\value{
cleaned strings
}
\description{
\code{clean_strings} takes a string vector and cleans it according to user-given options.
}
\details{
This function takes a variety of options, each of which changes the behavior.
Without the default settings, \code{clean_strings} will do the following:
make the string lowercase; replace special characters &, $, \\%, @ , with their
names ("and", "dollar", "percent", "at"); convert tabs to spaces and removes extra spaces.
This default cleaning puts the strings in a standard format to allow for easier matching.

The other options allow for the removal or replacement of other words or characters.
}
