% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{committees}
\alias{committees}
\title{Committees metadata}
\format{
A data frame with 17654 rows and 15 columns with information about FEC committees.
\describe{
\item{cmte_id}{A 9-character alpha-numeric code assigned to a committee by the Federal Election Commission}
\item{cmte_nm}{Name of the committee}
\item{tres_nm}{The officially registered treasurer for the committee}
\item{cmte_st1}{Street 1}
\item{cmte_st2}{Street 2}
\item{cmte_city}{City}
\item{cmte_st}{State}
\item{cmte_zip}{ZIP Code}
\item{cmte_dsgn}{A = Authorized by a candidate

B = Lobbyist/Registrant PAC

D = Leadership PAC

J = Joint fundraiser

P = Principal campaign committee of a candidate

U = Unauthorized}
\item{cmte_tp}{Committee Type, listed here: \url{https://www.fec.gov/campaign-finance-data/committee-type-code-descriptions/}}
\item{cmte_pty_affiliation}{Committee Party, listed here: \url{https://www.fec.gov/campaign-finance-data/party-code-descriptions/}}
\item{cmte_filing_freq}{Filing frequency: A = Administratively terminated,

D = Debt

M = Monthly filer

Q = Quarterly filer

T = Terminated

W = Waived}
\item{org_tp}{Interest group category:

C = Corporation

L = Labor organization

M = Membership organization

T = Trade association

V = Cooperative

W = Corporation without capital stock}
\item{connected_org_nm}{Connected organization's name}
\item{cand_id}{Candidate identification:When a committee has a committee type designation of H, S, or P,
the candidate's identification number will be entered in this field.}
}
}
\source{
\url{https://www.fec.gov/campaign-finance-data/committee-master-file-description/}, updated 2020-03-02
}
\usage{
committees
}
\description{
Provides data pertaining to each committee registered with the Federal Election Commission.
}
\keyword{datasets}
