% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runallmodels.R
\name{dtreevoting}
\alias{dtreevoting}
\title{Decision tree voting scheme.
Implements a feature selection approach based on Decision Trees, using a voting scheme across the top levels on trees trained on multiple subsamples.}
\usage{
dtreevoting(num_runs = 100, num_levels = 10, file_path = file_path)
}
\arguments{
\item{num_runs}{Number of subsamples to use for voting scheme (default: 100)}

\item{num_levels}{Number of levels in each tree to consider. Only the features which appear in the top num_levels levels of the trees (from the root) will be counted}

\item{file_path}{Where the num_runs subsample files are found (e.g. if sample 10 is at 'subsamples/sample10.csv' then file_path should be 'subsamples/sample'). There must be enough samples to fulfill num_runs runs.}
}
\value{
Outputs a dataframe containing (first column) total number of appearances of each feature (each row is a feature). The rest of the columns represent 1 run each and contain the level at which the feature appears.
}
\description{
Decision tree voting scheme.
Implements a feature selection approach based on Decision Trees, using a voting scheme across the top levels on trees trained on multiple subsamples.
}
\examples{
dtreevoting(
  num_runs=5,
  num_levels=10,
  file_path=paste(system.file('samples/subsamples', package = "feamiR"),'/sample',sep=''))
}
\keyword{decision}
\keyword{dtree}
\keyword{scheme}
\keyword{tree}
\keyword{voting}
