% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{CART}
\alias{CART}
\title{Classification using CART}
\usage{
CART(
  train,
  labels,
  minsplit = 1,
  maxdepth = log2(length(labels)),
  cp = NULL,
  tune = FALSE,
  ...
)
}
\arguments{
\item{train}{The training set (description), as a \code{data.frame}.}

\item{labels}{Class labels of the training set (\code{vector} or \code{factor}).}

\item{minsplit}{The minimum leaf size during the learning.}

\item{maxdepth}{Set the maximum depth of any node of the final tree, with the root node counted as depth 0.}

\item{cp}{The complexity parameter of the tree. Cross-validation is used to determine optimal cp if NULL.}

\item{tune}{If true, the function returns paramters instead of a classification model.}

\item{...}{Other parameters.}
}
\value{
The classification model.
}
\description{
This function builds a classification model using CART.
}
\examples{
require (datasets)
data (iris)
CART (iris [, -5], iris [, 5])
}
\seealso{
\code{\link{cartdepth}}, \code{\link{cartinfo}}, \code{\link{cartleafs}}, \code{\link{cartnodes}}, \code{\link{cartplot}}, \code{\link[rpart]{rpart}}
}
