% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{performance}
\alias{performance}
\title{Performance estimation}
\usage{
performance(
  methods,
  train.x,
  train.y,
  test.x = NULL,
  test.y = NULL,
  train.size = round(0.7 * nrow(train.x)),
  type = c("evaluation", "confusion", "roc", "cost", "scatter"),
  protocol = c("bootstrap", "crossvalidation", "loocv", "holdout", "train"),
  eval = ifelse(is.factor(train.y), "accuracy", "r2"),
  nruns = 10,
  nfolds = 10,
  new = TRUE,
  lty = 1,
  seed = NULL,
  methodparameters = NULL,
  names = NULL,
  ...
)
}
\arguments{
\item{methods}{The classification or regression methods to be evaluated.}

\item{train.x}{The dataset (description/predictors), a \code{matrix} or \code{data.frame}.}

\item{train.y}{The target (class labels or numeric values), a \code{factor} or \code{vector}.}

\item{test.x}{The test dataset (description/predictors), a \code{matrix} or \code{data.frame}.}

\item{test.y}{The (test) target (class labels or numeric values), a \code{factor} or \code{vector}.}

\item{train.size}{The size of the training set (holdout estimation).}

\item{type}{The type of evaluation (confusion matrix, ROC curve, ...)}

\item{protocol}{The evaluation protocol (crossvalidation, bootstrap, ...)}

\item{eval}{The evaluation functions.}

\item{nruns}{The number of bootstrap runs.}

\item{nfolds}{The number of folds (crossvalidation estimation).}

\item{new}{A logical value indicating whether a new plot should be be created or not (cost curves or ROC curves).}

\item{lty}{The line type (and color) specified as an integer (cost curves or ROC curves).}

\item{seed}{A specified seed for random number generation (useful for testing different method with the same bootstap samplings).}

\item{methodparameters}{Method parameters (if null tuning is done by cross-validation).}

\item{names}{Method names.}

\item{...}{Other specific parameters for the leaning method.}
}
\value{
The evaluation of the predictions (numeric value).
}
\description{
Estimate the performance of classification or regression methods using bootstrap or crossvalidation (accuracy, ROC curves, confusion matrices, ...)
}
\examples{
\dontrun{
require ("datasets")
data (iris)
# One method, one evaluation criterion, bootstrap estimation
performance (NB, iris [, -5], iris [, 5], seed = 0)
# One method, two evaluation criteria, train set estimation
performance (NB, iris [, -5], iris [, 5], eval = c ("accuracy", "kappa"),
             protocol = "train", seed = 0)
# Three methods, ROC curves, LOOCV estimation
performance (c (NB, LDA, LR), linsep [, -3], linsep [, 3], type = "roc",
             protocol = "loocv", seed = 0)
# List of methods in a variable, confusion matrix, hodout estimation
classif = c (NB, LDA, LR)
performance (classif, iris [, -5], iris [, 5], type = "confusion",
             protocol = "holdout", seed = 0, names = c ("NB", "LDA", "LR"))
# List of strings (method names), scatterplot evaluation, crossvalidation estimation
classif = c ("NB", "LDA", "LR")
performance (classif, iris [, -5], iris [, 5], type = "scatter",
             protocol = "crossvalidation", seed = 0)
}
}
\seealso{
\code{\link{confusion}}, \code{\link{evaluation}}, \code{\link{cost.curves}}, \code{\link{roc.curves}}
}
