% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{evaluation}
\alias{evaluation}
\title{Evaluation of classification or regression predictions}
\usage{
evaluation(predictions, targets, eval = ifelse(is.factor(targets),
  "accuracy", "r2"), ...)
}
\arguments{
\item{predictions}{The predictions of a classification model (\code{factor} or \code{vector}).}

\item{targets}{The actual targets of the dataset (\code{factor} or \code{vector}).}

\item{eval}{The evaluation method.}

\item{...}{Other parameters.}
}
\value{
The evaluation of the predictions (numeric value).
}
\description{
Evaluation predictions of a classification or a regression model.
}
\examples{
require (datasets)
data (iris)
d = splitdata (iris, 5)
model.nb = NB (d$train.x, d$train.y)
pred.nb = predict (model.nb, d$test.x)
# Default evaluation for classification
evaluation (pred.nb, d$test.y)
# Evaluation with two criteria
evaluation (pred.nb, d$test.y, eval = c ("accuracy", "kappa"))

data (trees)
d = splitdata (trees, 3)
model.linreg = LINREG (d$train.x, d$train.y)
pred.linreg = predict (model.linreg, d$test.x)
# Default evaluation for regression
evaluation (pred.linreg, d$test.y)
}
\seealso{
\code{\link{evaluation.accuracy}}, \code{\link{evaluation.fmeasure}}, \code{\link{evaluation.fowlkesmallows}}, \code{\link{evaluation.goodness}}, \code{\link{evaluation.jaccard}}, \code{\link{evaluation.kappa}},
\code{\link{evaluation.precision}}, \code{\link{evaluation.recall}},
\code{\link{evaluation.msep}}, \code{\link{evaluation.r2}}
}
