% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{boxclus}
\alias{boxclus}
\title{Clustering Box Plots}
\usage{
boxclus(d, clusters, legendpos = "topleft", ...)
}
\arguments{
\item{d}{The dataset (\code{matrix} or \code{data.frame}).}

\item{clusters}{Cluster labels of the training set (\code{vector} or \code{factor}).}

\item{legendpos}{Position of the legend}

\item{...}{Other parameters.}
}
\description{
Produce a box-and-whisker plot for clustering results.
}
\examples{
require (datasets)
data (iris)
km = KMEANS (iris [, -5], k = 3)
boxclus (iris [, -5], km$cluster)
}
\seealso{
\code{\link[graphics]{boxplot}}
}
