% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{SVR}
\alias{SVR}
\title{Regression using Support Vector Machine}
\usage{
SVR(x, y, gamma = 2^(-3:3), cost = 2^(-3:3), kernel = c("radial",
  "linear"), epsilon = c(0.1, 0.5, 1), params = NULL, tune = FALSE,
  ...)
}
\arguments{
\item{x}{Predictor \code{matrix}.}

\item{y}{Response \code{vector}.}

\item{gamma}{The gamma parameter (if a vector, cross-over validation is used to chose the best size).}

\item{cost}{The cost parameter (if a vector, cross-over validation is used to chose the best size).}

\item{kernel}{The kernel type.}

\item{epsilon}{The epsilon parameter (if a vector, cross-over validation is used to chose the best size).}

\item{params}{Object containing the parameters. If given, it replaces \code{epsilon}, \code{gamma} and \code{cost}.}

\item{tune}{If true, the function returns paramters instead of a classification model.}

\item{...}{Other arguments.}
}
\value{
The classification model.
}
\description{
This function builds a regression model using Support Vector Machine.
}
\examples{
require (datasets)
data (trees)
SVR (trees [, -3], trees [, 3], kernel = "linear", cost = 1)
SVR (trees [, -3], trees [, 3], kernel = "radial", gamma = 1, cost = 1)
}
\seealso{
\code{\link[e1071]{svm}}, \code{\link{SVRl}}, \code{\link{SVRr}}
}
