% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertFPCA.R
\name{vertFPCA}
\alias{vertFPCA}
\title{Vertical Functional Principal Component Analysis}
\usage{
vertFPCA(fn, time, qn, no, showplot = TRUE)
}
\arguments{
\item{fn}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} aligned functions with \eqn{N} samples}

\item{time}{vector of size \eqn{N} describing the sample points}

\item{qn}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} of aligned srvfs}

\item{no}{number of prinicpal components to extract}

\item{showplot}{show plots of prinipal directions (default = T)}
}
\value{
Returns a list containing \item{q_pca}{srvf principal directions}
\item{f_pca}{f principal directions}
\item{latent}{latent values}
\item{coef}{coefficients}
\item{U}{eigenvectors}
}
\description{
This function calculates vertical functional principal component analysis
on aligned data
}
\examples{
data("simu_warp")
data("simu_data")
vfpca = vertFPCA(simu_warp$fn,simu_data$time,simu_warp$qn,no = 3)
}
\references{
Tucker, J. D., Wu, W., Srivastava, A.,
 Generative Models for Function Data using Phase and Amplitude Separation,
 Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srvf}
