% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FClust.R
\name{FClust}
\alias{FClust}
\title{Functional clustering and identifying substructures of longitudinal data}
\usage{
FClust(Ly, Lt, k = 3, cmethod = "EMCluster", optnsFPCA = NULL,
  optnsCS = NULL)
}
\arguments{
\item{Ly}{A list of \emph{n} vectors containing the observed values for each individual. Missing values specified by \code{NA}s are supported for dense case (\code{dataType='dense'}).}

\item{Lt}{A list of \emph{n} vectors containing the observation time points for each individual corresponding to y.}

\item{k}{A scalar defining the number of clusters to define; default 3.}

\item{cmethod}{A string specifying the clusterig method to use ('EMCluster' or 'kCFC'); default: 'EMCluster'.}

\item{optnsFPCA}{A list of options control parameters specified by \code{list(name=value)} to be used for by FPCA on the sample y; by default: 
"list( methodMuCovEst ='smooth', FVEthreshold= 0.90, methodBwCov = 'GCV', methodBwMu = 'GCV' )". See `Details in ?FPCA'.}

\item{optnsCS}{A list of options control parameters specified by \code{list(name=value)} to be used for cluster-specific FPCA from kCFC; by default:
"list( methodMuCovEst ='smooth', FVEthreshold= 0.70, methodBwCov = 'GCV', methodBwMu = 'GCV' )". See `Details in ?FPCA' and '?kCFC'. This is not used by Rmixmod!}
}
\value{
A list containing the following fields:
\item{cluster}{A vector of levels 1:k, indicating the cluster to which each curve is allocated.} 
\item{fpca}{An FPCA object derived from the sample used by Rmixmod, otherwise NULL.} 
\item{clusterObj}{Either a EMCluster object or kCFC object.}
}
\description{
By default the function will cluster the data using the functional principal component (FPC) scores from the data's 
FPC analysis using EMCluster (Chen and Maitra, 2015) or directly clustering the functional data using kCFC (Chiou and Li, 2007).
}
\details{
Within EMCluster we examine the model initiated "EMCluster::em.EM" and return the optimal model based on 'EMCluster::emcluster'. 
See ?EMCluster::emcluster for details.
}
\examples{
\dontrun{
data(medfly25)
Flies <- MakeFPCAInputs(medfly25$ID, medfly25$Days, medfly25$nEggs) 
newClust <- FClust(Flies$Ly, Flies$Lt, k = 2, optnsFPCA = 
                    list(methodMuCovEst = 'smooth', userBwCov = 2, FVEthreshold = 0.90))
                    
# We denote as 'veryLowCount' the group of flies that lay less
# than twenty-five eggs during the 25-day period examined.

veryLowCount = ifelse( sapply( unique(medfly25$ID), function(u) 
                   sum( medfly25$nEggs[medfly25$ID == u] )) < 25, 0, 1)
N <- length(unique(medfly25$ID))
(correctRate <- sum( (1 + veryLowCount) ==  newClust$cluster) / N) # 99.6\%
}
}
\references{
\cite{Wei-Chen Chen and Ranjan Maitra, "EMCluster: EM Algorithm for Model-Based Clusttering of Finite Mixture Gaussian Distribution". (2015)}

\cite{Julien Jacques and Cristian Preda, "Funclust: A curves clustering method using functional random variables density approximation". Neurocomputing 112 (2013): 164-171}

\cite{Jeng-Min Chiou and Pai-Ling Li, "Functional clustering and identifying substructures of longitudinal data". Journal of the Royal Statistical Society B 69 (2007): 679-699}
}
