% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestFunctions.R
\name{fEqMoments.test}
\alias{fEqMoments.test}
\alias{fmean.test.fdata}
\alias{cov.test.fdata}
\title{Tests for checking the equality of means and/or covariance between two populations under gaussianity.}
\usage{
fmean.test.fdata(
  X.fdata,
  Y.fdata,
  method = c("X2", "Boot"),
  npc = 5,
  alpha = 0.95,
  B = 1000,
  draw = FALSE
)

cov.test.fdata(
  X.fdata,
  Y.fdata,
  method = c("X2", "Boot"),
  npc = 5,
  alpha = 0.95,
  B = 1000,
  draw = FALSE
)
}
\arguments{
\item{X.fdata}{\code{fdata} object containing the curves from the first population.}

\item{Y.fdata}{\code{fdata} object containing the curves from the second population.}

\item{method}{c("X2","Boot"). "X2" includes the asymptotic distribution. "Boot" computes the bootstrap approximation.}

\item{npc}{The number of principal components employed. If \code{npc} is negative and 0<\code{abs(npc)}<1, the number of components 
are determined for explaining, at least, \code{abs(p)}\% of variability.}

\item{alpha}{Confidence level. By default =0.95.}

\item{B}{Number of bootstrap replicas when method="Boot".}

\item{draw}{By default, FALSE. Plots the density of the bootstrap replicas jointly with the statistic.}
}
\value{
Return a list with:
\itemize{
\item {stat}{ Value of the statistic.} 
\item {pvalue}{ P-values for the test.}
\item {vcrit}{ Critical cutoff for rejecting the null hypothesis.}
\item {p}{ Degrees of freedom for X2 statistic. }
\item {B}{ Number of bootstrap replicas.}
}
}
\description{
Two tests for the equality of means and covariances of two populations are provided.
 Both tests are constructed under gaussianity following Horvath & Kokoszka, 2012, Chapter 5.
}
\details{
\code{\link{fmean.test.fdata}} computes the test for equality of means. 
\code{\link{cov.test.fdata}} computes the test for equality of covariance operators.
Both tests have asymptotic distributions under the null related with chi-square distribution. Also, a 
parametric bootstrap procedure is implemented in both cases.
}
\examples{
\dontrun{
tt=seq(0,1,len=51)
bet=0
mu1=fdata(10*tt*(1-tt)^(1+bet),tt)
mu2=fdata(10*tt^(1+bet)*(1-tt),tt) 
fsig=1
X=rproc2fdata(100,tt,mu1,sigma="vexponential",par.list=list(scale=0.2,theta=0.35))
Y=rproc2fdata(100,tt,mu2,sigma="vexponential",par.list=list(scale=0.2*fsig,theta=0.35))
fmean.test.fdata(X,Y,npc=-.98,draw=TRUE)
cov.test.fdata(X,Y,npc=5,draw=TRUE)
bet=0.1
mu1=fdata(10*tt*(1-tt)^(1+bet),tt)
mu2=fdata(10*tt^(1+bet)*(1-tt),tt) 
fsig=1.5
X=rproc2fdata(100,tt,mu1,sigma="vexponential",par.list=list(scale=0.2,theta=0.35))
Y=rproc2fdata(100,tt,mu2,sigma="vexponential",par.list=list(scale=0.2*fsig,theta=0.35))
fmean.test.fdata(X,Y,npc=-.98,draw=TRUE)
cov.test.fdata(X,Y,npc=5,draw=TRUE)
}

}
\references{
Inference for Functional Data with Applications. Horvath, L and Kokoszka, P. (2012). Springer.
}
\seealso{
See Also as \code{\link{fanova.RPm}, \link{fanova.onefactor}}.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.febrero@usc.es}
}
\keyword{htest}
