% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldata.R
\name{ldata}
\alias{ldata}
\alias{c.ldata}
\alias{is.ldata}
\alias{names.ldata}
\alias{[.ldata}
\alias{plot.ldata}
\alias{subset.ldata}
\title{ldata class definition and utilities}
\usage{
ldata(df, ...)

\method{names}{ldata}(x)

is.ldata(x)

\method{[}{ldata}(ldata, i)

\method{subset}{ldata}(x, subset, ...)

\method{plot}{ldata}(x, ask = FALSE, color, var.name, ...)
}
\arguments{
\item{df}{data frame}

\item{\dots}{Further arguments passed to methods.}

\item{ldata, x}{object of class \code{ldata}}

\item{i}{index}

\item{subset}{subset}

\item{ask}{logilcal    If TRUE (and the R session is interactive) the user is asked for input, before a new figure is drawn.}

\item{color}{colors to interpolate; must be a valid argument to  \code{colorRampPalette}.}

\item{var.name}{name of continuous univariate variable used in \code{color} argument}
}
\description{
ldata is a listt with two type of objects:
\itemize{
\item \code{df} is a data frame with the multivariate data with n rows.
\item \code{...}  fdata objects of class \code{fdata} with n rows.
}
}
\examples{
data(tecator)
ab0 <- tecator$absorp.fdata
ab1 <- fdata.deriv(ab0)
ab2 <- fdata.deriv(ab0,nderiv=2)
ldat<-ldata(tecator$y,ab1,ab2)
is.ldata(ldat)
class(ldat)
plot(ldat[[1]])
plot(ldat[[2]]) 
# plot(ldat)
# plot(ldat,var.name="Fat")

}
