% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implication_set.R
\name{ImplicationSet}
\alias{ImplicationSet}
\title{R6 Class for Set of implications}
\description{
This class implements the structure needed to store implications and the methods associated.
}
\examples{
# Build a formal context
fc_planets <- FormalContext$new(planets)

# Find its implication basis
fc_planets$find_implications()

# Print implications
fc_planets$implications

# Cardinality and mean size in the ruleset
fc_planets$implications$cardinality()
sizes <- fc_planets$implications$size()
colMeans(sizes)

# Simplify the implication set
fc_planets$implications$apply_rules("simplification")

}
\references{
Ganter B, Obiedkov S (2016). Conceptual Exploration. Springer. https://doi.org/10.1007/978-3-662-49291-8

Hahsler M, Grun B, Hornik K (2005). “arules - a computational environment for mining association rules and frequent item sets.” \emph{J Stat Softw}, \emph{14}, 1-25.

Belohlavek R, Cordero P, Enciso M, Mora Á, Vychodil V (2016). “Automated prover for attribute dependencies in data with grades.” \emph{International Journal of Approximate Reasoning}, \emph{70}, 51-67.

Mora A, Cordero P, Enciso M, Fortes I, Aguilera G (2012). “Closure via functional dependence simplification.” \emph{International Journal of Computer Mathematics}, \emph{89}(4), 510-526.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ImplicationSet-new}{\code{ImplicationSet$new()}}
\item \href{#method-ImplicationSet-get_attributes}{\code{ImplicationSet$get_attributes()}}
\item \href{#method-ImplicationSet-bracket}{\code{ImplicationSet$[()}}
\item \href{#method-ImplicationSet-to_arules}{\code{ImplicationSet$to_arules()}}
\item \href{#method-ImplicationSet-add}{\code{ImplicationSet$add()}}
\item \href{#method-ImplicationSet-cardinality}{\code{ImplicationSet$cardinality()}}
\item \href{#method-ImplicationSet-is_empty}{\code{ImplicationSet$is_empty()}}
\item \href{#method-ImplicationSet-size}{\code{ImplicationSet$size()}}
\item \href{#method-ImplicationSet-closure}{\code{ImplicationSet$closure()}}
\item \href{#method-ImplicationSet-recommend}{\code{ImplicationSet$recommend()}}
\item \href{#method-ImplicationSet-apply_rules}{\code{ImplicationSet$apply_rules()}}
\item \href{#method-ImplicationSet-to_basis}{\code{ImplicationSet$to_basis()}}
\item \href{#method-ImplicationSet-to_direct_optimal}{\code{ImplicationSet$to_direct_optimal()}}
\item \href{#method-ImplicationSet-print}{\code{ImplicationSet$print()}}
\item \href{#method-ImplicationSet-to_latex}{\code{ImplicationSet$to_latex()}}
\item \href{#method-ImplicationSet-get_LHS_matrix}{\code{ImplicationSet$get_LHS_matrix()}}
\item \href{#method-ImplicationSet-get_RHS_matrix}{\code{ImplicationSet$get_RHS_matrix()}}
\item \href{#method-ImplicationSet-filter}{\code{ImplicationSet$filter()}}
\item \href{#method-ImplicationSet-support}{\code{ImplicationSet$support()}}
\item \href{#method-ImplicationSet-use_logic}{\code{ImplicationSet$use_logic()}}
\item \href{#method-ImplicationSet-get_logic}{\code{ImplicationSet$get_logic()}}
\item \href{#method-ImplicationSet-use_hedge}{\code{ImplicationSet$use_hedge()}}
\item \href{#method-ImplicationSet-get_hedge}{\code{ImplicationSet$get_hedge()}}
\item \href{#method-ImplicationSet-clone}{\code{ImplicationSet$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-new"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-new}{}}}
\subsection{Method \code{new()}}{
Initialize with an optional name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See Details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Creates and initialize a new \code{ImplicationSet} object. It can be done in two ways:
\code{initialize(name, attributes, lhs, rhs)}
or \code{initialize(rules)}

In the first way, the only mandatory argument is \code{attributes}, (character vector) which is a vector of names of the attributes on which we define the implications. Optional arguments are: \code{name} (character string), name of the implication set, \code{lhs} (a \code{dgCMatrix}), initial LHS of the implications stored and the analogous \code{rhs}.

The other way is used to initialize the \code{ImplicationSet} object from a \code{rules} object from package \code{arules}.
}

\subsection{Returns}{
A new \code{ImplicationSet} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-get_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-get_attributes}{}}}
\subsection{Method \code{get_attributes()}}{
Get the names of the attributes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$get_attributes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector with the names of the attributes used in the implications.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-bracket"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-bracket}{}}}
\subsection{Method \code{[()}}{
Get a subset of the implication set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$[(idx)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{idx}}{(integer or logical vector) Indices of the implications to extract or remove. If logical vector, only \code{TRUE} elements are retained and the rest discarded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ImplicationSet} with only the rules given by the \code{idx} indices (if all \code{idx > 0} and all but \code{idx} if all \code{idx < 0}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-to_arules"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-to_arules}{}}}
\subsection{Method \code{to_arules()}}{
Convert to arules format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$to_arules(quality = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{quality}}{(logical) Compute the interest measures for each rule?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{rules} object as used by package \code{arules}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-add"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-add}{}}}
\subsection{Method \code{add()}}{
Add a precomputed implication set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$add(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{An \code{ImplicationSet} object, a \code{rules} object, or a pair \code{lhs}, \code{rhs} of \code{Set} objects or \code{dgCMatrix}. The implications to add to this formal context.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing, just updates the internal \code{implications} field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-cardinality"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-cardinality}{}}}
\subsection{Method \code{cardinality()}}{
Cardinality: Number of implications in the set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$cardinality()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The cardinality of the implication set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-is_empty"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-is_empty}{}}}
\subsection{Method \code{is_empty()}}{
Empty set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$is_empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if the set of implications is empty, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-size"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-size}{}}}
\subsection{Method \code{size()}}{
Size: number of attributes in each of LHS and RHS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector with two components: the number of attributes present in each of the LHS and RHS of each implication in the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-closure"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-closure}{}}}
\subsection{Method \code{closure()}}{
Compute the semantic closure of a fuzzy set with respect to the implication set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$closure(S, reduce = FALSE, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{(a \code{Set} object)  Fuzzy set to compute its closure. Use class \code{Set} to build it.}

\item{\code{reduce}}{(logical) Reduce the implications using simplification logic?}

\item{\code{verbose}}{(logical) Show verbose output?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{reduce == FALSE}, the output is a fuzzy set corresponding to the closure of \code{S}. If \code{reduce == TRUE}, a list with two components: \code{closure}, with the closure as above, and \code{implications}, the reduced set of implications.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-recommend"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-recommend}{}}}
\subsection{Method \code{recommend()}}{
Generate a recommendation for a subset of the attributes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$recommend(S, attribute_filter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{(a vector) Vector with the grades of each attribute (a fuzzy set).}

\item{\code{attribute_filter}}{(character vector) Names of the attributes to get recommendation for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A fuzzy set describing the values of the attributes in \code{attribute_filter} within the closure of \code{S}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-apply_rules"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-apply_rules}{}}}
\subsection{Method \code{apply_rules()}}{
Apply rules to remove redundancies
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$apply_rules(
  rules = c("composition", "generalization"),
  batch_size = 25000L,
  parallelize = FALSE,
  reorder = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rules}}{(character vector) Names of the rules to use. See \code{details}.}

\item{\code{batch_size}}{(integer) If the number of rules is large, apply the rules by batches of this size.}

\item{\code{parallelize}}{(logical) If possible, should we parallelize the computation among different batches?}

\item{\code{reorder}}{(logical) Should the rules be randomly reordered previous to the computation?}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Currently, the implemented rules are \code{"generalization"}, \code{"simplification"}, \code{"reduction"} and \code{"composition"}.
}

\subsection{Returns}{
Nothing, just updates the internal matrices for LHS and RHS.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-to_basis"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-to_basis}{}}}
\subsection{Method \code{to_basis()}}{
Convert Implications to Canonical Basis
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$to_basis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The canonical basis of implications obtained from the current \code{ImplicationSet}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-to_direct_optimal"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-to_direct_optimal}{}}}
\subsection{Method \code{to_direct_optimal()}}{
Compute the Direct Optimal Basis using optimized C++ algorithms.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$to_direct_optimal(
  method = c("direct_optimal", "final_ts", "monotonic", "priority"),
  verbose = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{(character) The specific algorithm to run:
\itemize{
\item \code{"direct_optimal"}: (Default) The Direct Optimal Saturation-Pruning algorithm.
\item \code{"final_ts"}: Computes Transitive Closure then Prunes (Standard approach).
\item \code{"monotonic"}: Incremental algorithm maintaining monotonicity.
\item \code{"priority"}: Priority-based refinement algorithm.
}}

\item{\code{verbose}}{(logical) Print verbose output from the C++ backend.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing, updates the \code{ImplicationSet} in place with the new basis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-print"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-print}{}}}
\subsection{Method \code{print()}}{
Print all implications to text
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string with all the implications in the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-to_latex"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-to_latex}{}}}
\subsection{Method \code{to_latex()}}{
Export to LaTeX
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$to_latex(
  print = TRUE,
  ncols = 1,
  numbered = TRUE,
  numbers = seq(self$cardinality())
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{print}}{(logical) Print to output?}

\item{\code{ncols}}{(integer) Number of columns for the output.}

\item{\code{numbered}}{(logical) If \code{TRUE} (default), implications will be numbered in the output.}

\item{\code{numbers}}{(vector) If \code{numbered}, use these elements to enumerate the implications. The default is to enumerate 1, 2, ..., but can be changed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A string in LaTeX format that prints nicely all the implications.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-get_LHS_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-get_LHS_matrix}{}}}
\subsection{Method \code{get_LHS_matrix()}}{
Get internal LHS matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$get_LHS_matrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A sparse matrix representing the LHS of the implications in the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-get_RHS_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-get_RHS_matrix}{}}}
\subsection{Method \code{get_RHS_matrix()}}{
Get internal RHS matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$get_RHS_matrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A sparse matrix representing the RHS of the implications in the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-filter"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-filter}{}}}
\subsection{Method \code{filter()}}{
Filter implications by attributes in LHS and RHS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$filter(
  lhs = NULL,
  not_lhs = NULL,
  rhs = NULL,
  not_rhs = NULL,
  drop = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lhs}}{(character vector) Names of the attributes to filter the LHS by. If \code{NULL}, no filtering is done on the LHS.}

\item{\code{not_lhs}}{(character vector) Names of the attributes to not include in the LHS. If \code{NULL} (the default), it is not considered at all.}

\item{\code{rhs}}{(character vector) Names of the attributes to filter the RHS by. If \code{NULL}, no filtering is done on the RHS.}

\item{\code{not_rhs}}{(character vector) Names of the attributes to not include in the RHS. If \code{NULL} (the default), it is not considered at all.}

\item{\code{drop}}{(logical) Remove the rest of attributes in RHS?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{ImplicationSet} that is a subset of the current set, only with those rules which has the attributes in \code{lhs} and \code{rhs} in their LHS and RHS, respectively.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-support"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-support}{}}}
\subsection{Method \code{support()}}{
Compute support of each implication
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$support()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector with the support of each implication
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-use_logic"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-use_logic}{}}}
\subsection{Method \code{use_logic()}}{
Sets the logic to use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$use_logic(name = available_logics())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the logic to use. To see the available names, run \code{available_logics()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-get_logic"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-get_logic}{}}}
\subsection{Method \code{get_logic()}}{
Gets the logic used
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$get_logic()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string with the name of the logic.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-use_hedge"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-use_hedge}{}}}
\subsection{Method \code{use_hedge()}}{
Sets the hedge to use when computing closures
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$use_hedge(name = c("globalization", "identity"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the hedge to use. Only "globalization" and "identity" are allowed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-get_hedge"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-get_hedge}{}}}
\subsection{Method \code{get_hedge()}}{
Gets the hedge used to compute closures
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$get_hedge()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string with the name of the hedge
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
