% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_model_helpers.R
\name{align_survival_curve}
\alias{align_survival_curve}
\title{Align Survival Curve to Evaluation Times}
\usage{
align_survival_curve(curve_times, curve_surv, eval_times)
}
\arguments{
\item{curve_times}{Numeric vector of time points from the survival curve.}

\item{curve_surv}{Numeric vector of survival probabilities corresponding to
\code{curve_times}.}

\item{eval_times}{Numeric vector of new time points to evaluate at.}
}
\value{
A numeric vector of survival probabilities at \code{eval_times}.
}
\description{
Aligns a survival curve (defined by time points and survival probabilities)
to a new set of evaluation times using constant interpolation (last value
carried forward). Ensures \eqn{S(0) = 1} and monotonicity.
}
\keyword{internal}
