% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd_ma}
\alias{fastcpd_ma}
\alias{fastcpd.ma}
\title{Find change points efficiently in MA(q) models}
\usage{
fastcpd_ma(data, order = 0, ...)

fastcpd.ma(data, order = 0, ...)
}
\arguments{
\item{data}{A numeric vector, a matrix, a data frame or a time series object.}

\item{order}{A positive integer or a vector of length three with the first
two elements being zeros specifying the order of the MA model.}

\item{...}{Other arguments passed to \code{\link{fastcpd}}, for example,
\code{segment_count}. One special argument can be passed here is
\code{include.mean}, which is a logical value indicating whether the
mean should be included in the model. The default value is \code{TRUE}.}
}
\value{
A class \code{fastcpd} object.
}
\description{
\code{fastcpd_ma} and \code{fastcpd.ma} are
wrapper functions of \code{\link{fastcpd}} to find change points in
MA(q) models. The function is similar to \code{\link{fastcpd}}
except that the data is by default a one-column matrix or univariate vector
and thus a formula is not required here.
}
\examples{
\donttest{
if (!requireNamespace("ggplot2", quietly = TRUE)) utils::install.packages(
  "ggplot2", repos = "https://cloud.r-project.org", quiet = TRUE
)

set.seed(1)
n <- 400
w <- rnorm(n + 4, 0, 0.1)
x <- rep(NA, n)
for (i in 1:200) {
  x[i] <- w[i + 4] - 5 / 3 * w[i + 3] + 11 / 12 * w[i + 2] - 5 / 12 * w[i + 1] +
    1 / 6 * w[i]
}
for (i in 201:n) {
  x[i] <- w[i + 4] - 4 / 3 * w[i + 3] + 7 / 9 * w[i + 2] - 16 / 27 * w[i + 1] +
    4 / 27 * w[i]
}
result <- suppressMessages(
  fastcpd.ma(x, 4, include.mean = FALSE, trim = 0)
)
summary(result)
plot(result)
}
}
