% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Ice}
\alias{Ice}
\title{Cooling muscles with ice}
\source{
Dykstra, J. H., Hill, H. M., Miller, M. G., Michael T. J., Cheatham,
C. C., and Baker, R.J., Comparisons of cubed ice, crushed ice, and wetted
ice on intramuscular and surface temperature changes, \emph{Journal of
Athletic Training} 44 (2009), no. 2, 136--141.
}
\description{
This data set contains the results of an experiment comparing the efficacy
of different forms of dry ice application in reducing the temperature of the
calf muscle.
}
\details{
The 12 subjects in this study came three times, at least four days apart,
and received one of three ice treatments (cubed ice, crushed ice, or ice
mixed with water). In each case, the ice was prepared in a plastic bag and
applied dry to the subjects calf muscle.  The temperature measurements were
taken on the skin surface and inside the calf muscle (via a 4 cm long probe)
every 30 seconds for 20 minutes prior to icing, for 20 minutes during icing,
and for 2 hours after the ice had been removed.  The temperature
measurements are stored in variables that begin with \code{b} (baseline),
\code{t} (treatment), or \code{r} (recovery) followed by a numerical code
for the elapsed time formed by concatenating the number of minutes and
seconds. For example, \code{R1230} contains the temperatures 12 minutes and
30 seconds after the ice had been removed.

Variables include \itemize{ \item{Subject}{ identification number}
\item{sex}{ a factor with levels \code{female} \code{male}}
\item{weight}{ weight of subject (kg)} \item{Height}{ height
of subject (cm)} \item{Skinfold}{ skinfold thickness}
\item{calf}{ calf diameter (cm)} \item{Age}{ age of subject}
\item{location}{ a factor with levels \code{intramuscular}
\code{surface}} \item{Treatment}{ a factor with levels \code{crushed}
\code{cubed} \code{wet}} \item{B0}{ baseline temperature at time 0}
\item{b30}{ baseline temperature 30 seconds after start}
\item{b100}{ baseline temperature 1 minute after start}
\item{b1930}{ baseline temperature 19 minutes 30 seconds start}
\item{t0}{ treatment temperature at beginning of treatment}
\item{t30}{ treatment temperature 30 seconds after start of
treatment} \item{t100}{ treatment temperature 1 minute after start of
treatment} \item{t1930}{ treatment temperature 19 minutes 30 seconds
after start of treatment} \item{R0}{ recovery temperature at start of
recovery} \item{r30}{ recovery temperature 30 seconds after start of
recovery} \item{r100}{ recovery temperature 1 minute after start of
recovery} \item{r12000}{ recovery temperature 120 minutes after start
of recovery} }
}
\examples{

data(Ice)
gf_point(weight ~ skinfold, color = ~ sex, data = Ice)
if (require(readr) && require(tidyr)) {
  Ice2 <- Ice \%>\% 
  gather("key", "temp", b0:r12000) \%>\% 
  separate(key, c("phase", "time"), sep = 1) \%>\% 
  mutate(time = parse_number(time), subject = as.character(subject))  
  
  gf_line( temp ~ time, data = Ice2 \%>\% filter(phase == "t"), 
           color = ~ sex,  group = ~subject, alpha = 0.6) \%>\%
    gf_facet_grid( treatment ~ location)
}

}
\keyword{datasets}
