% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rchol}
\alias{rchol}
\title{Cholesky decomposition via R factorization.}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix, with \eqn{n\geq p}. If \eqn{n< p} an error message is returned.}
}
\value{
an upper triangular matrix of dimension \eqn{p\times p} which represents the Cholesky decomposition of \eqn{X^\top X}.
}
\description{
rchol, provides the Cholesky decomposition of the symmetric and positive definite matrix \eqn{X^\top X\in\mathbb{R}^{p\times p}}, where \eqn{X\in\mathbb{R}^{n\times p}} is the input matrix.
}
\examples{

set.seed(1234)
n <- 10
p <- 6
X <- matrix(rnorm(n * p, 1), n, p)

## compute the Cholesky decomposition of X^TX
S <- fastQR::rchol(X = X)
S

## check
round(S - chol(crossprod(X)), 5)

}
\references{
\insertRef{golub_van_loan.2013}{fastQR}

\insertRef{bjorck.2015}{fastQR}

\insertRef{bjorck.2024}{fastQR}

\insertRef{bernardi_etal.2024}{fastQR}
}
