% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastNaiveBayes.detect_distribution.R,
%   R/fastNaiveBayes.detect_distribution.default.R
\name{fastNaiveBayes.detect_distribution}
\alias{fastNaiveBayes.detect_distribution}
\alias{fastNaiveBayes.detect_distribution.default}
\title{Distribution Detection Function}
\usage{
fastNaiveBayes.detect_distribution(x, nrows = 10)

\method{fastNaiveBayes.detect_distribution}{default}(x, nrows = 10)
}
\arguments{
\item{x}{a numeric matrix, or a dgcMatrix}

\item{nrows}{number of rows to use to detect distributions}

\item{...}{Not used.}
}
\value{
A list of distribution names mapped to column names
}
\description{
Determines which distribution to use for which columns in the matrix based
on a set of rules.
}
\details{
A simple utility function to detect the distribution to use for each columns
}
\examples{
rm(list = ls())
require(mlbench)
require(Matrix)

# Load BreastCancer data
data(BreastCancer)
dim(BreastCancer)
levels(BreastCancer$Class)
head(BreastCancer)

# Select couple of columns
data_mat <- BreastCancer[, c("Class", "Cl.thickness", "Cell.size", "Cell.shape", "Marg.adhesion")]

y <- data_mat[, "Class"]
data_mat <- data_mat[, setdiff(colnames(data_mat), c("Class"))]
for (i in 1:ncol(data_mat)) {
  data_mat[[i]] <- as.numeric(data_mat[[i]])
}

# Example using only Gaussian distribution
model <- fastNaiveBayes.mixed(data_mat[1:400, ], y[1:400],
  laplace = 1, sparse = TRUE,
  distribution = fastNaiveBayes.detect_distribution(data_mat)
)
preds <- predict(model, newdata = data_mat[401:nrow(data_mat), ], type = "class")

mean(preds != y[401:length(y)])
}
