% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_monthly_cumulative_stats.R
\name{calc_monthly_cumulative_stats}
\alias{calc_monthly_cumulative_stats}
\title{Calculate cumulative monthly flow statistics}
\usage{
calc_monthly_cumulative_stats(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  percentiles = c(5, 25, 75, 95),
  use_yield = FALSE,
  basin_area,
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  transpose = FALSE
)
}
\arguments{
\item{data}{A data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank if using \code{station_number} argument.}

\item{dates}{Column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not '
Date' (default). Leave blank if using \code{station_number} argument.}

\item{values}{Column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required if
groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if present.
Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} argument.}

\item{station_number}{A character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{percentiles}{Numeric vector of percentiles to calculate. Set to NA if none required. Default \code{c(5,25,75,95)}.}

\item{use_yield}{Logical value indicating whether to use yield runoff, in mm, instead of volumetric. Default \code{FALSE}.}

\item{basin_area}{Upstream drainage basin area, in square kilometres, to apply to observations. Three options:

(1) Leave blank if \code{groups} is STATION_NUMBER with HYDAT station numbers to extract basin areas from HYDAT.

(2) A single numeric value to apply to all observations.

(3) List each basin area for each group/station in groups (can override HYDAT value if listed) as such \code{c("08NM116" = 795, 
"08NM242" = 10)}. If group is not listed the HYDAT area will be applied if it exists, otherwise it will be NA.}

\item{water_year_start}{Numeric value indicating the month of the start of the water year for analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank to use the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank to use the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank to include all years.}

\item{transpose}{Logical value indicating if the results rows and columns are to be switched. Default \code{FALSE}.}
}
\value{
A tibble data frame with the following columns, default units in cubic metres, or millimetres if use_yield and basin_area provided:
  \item{Month}{month (MMM-DD) of cumulative statistics}
  \item{Mean}{monthly mean of all cumulative flows for a given month of the year}
  \item{Median}{monthly mean of all cumulative flows for a given month of the year}
  \item{Maximum}{monthly mean of all cumulative flows for a given month of the year}
  \item{Minimum}{monthly mean of all cumulative flows for a given month of the year}
  \item{P'n'}{each monthly n-th percentile selected of all cumulative flows for a given month of the year}
  Default percentile columns:
  \item{P5}{monthly 5th percentile of all cumulative flows for a given month of the year}
  \item{P25}{monthly 25th percentile of all cumulative flows for a given month of the year}
  \item{P75}{monthly 75th percentile of all cumulative flows for a given month of the year}
  \item{P95}{monthly 95th percentile of all cumulative flows for a given month of the year}
  Transposing data creates a column of "Statistics" and subsequent columns for each year selected.
}
\description{
Calculate cumulative monthly flow statistics for each month of the year of daily flow values from a streamflow dataset. 
   Calculates the statistics from all daily discharge values for each month from all years, unless specified. Defaults to volumetric 
   cumulative flows, can use \code{use_yield} and \code{basin_area} to convert to runoff yield.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Calculate annual monthly cumulative volume statistics
calc_monthly_cumulative_stats(station_number = "08NM116") 

# Calculate annual monthly cumulative volume statistics with default HYDAT basin area
calc_monthly_cumulative_stats(station_number = "08NM116",
                              use_yield = TRUE) 

# Calculate annual monthly cumulative volume statistics with custom basin area
calc_monthly_cumulative_stats(station_number = "08NM116",
                              use_yield = TRUE,
                              basin_area = 800) 
                              
}
}
