/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import jfm.model.Types;
import jfm.model.VariableHolder;
import jfm.model.WorkableHoursCalculator;
import jfm.xml.XMLSyntaxException;

public final class Location
extends VariableHolder {
    private final int numPeriods;
    private final double[] hoursCache;
    private final double[] freeTimeHoursCache;
    private static HashMap<Integer, double[]> freeTimeHoursMap;
    private static HashMap<Integer, double[]> hoursMap;
    public static HashMap<String, Integer> month;
    public static ArrayList<GregorianCalendar> periods26;
    public static ArrayList<GregorianCalendar> periods13;
    public static ArrayList<GregorianCalendar> periods2;
    public static HashMap<Integer, ArrayList<GregorianCalendar>> periodsmap;

    public Location(double st, double rf, int numPeriods_) {
        this.setVariable(Types.VariableType.SOILTYPE, st);
        this.setVariable(Types.VariableType.RAINFALL, rf);
        this.numPeriods = numPeriods_;
        this.hoursCache = new double[this.numPeriods];
        this.freeTimeHoursCache = new double[this.numPeriods];
        this.refreshHoursCache();
    }

    public Location copy() {
        return new Location(this.getVariable(Types.VariableType.SOILTYPE), this.getVariable(Types.VariableType.RAINFALL), this.numPeriods);
    }

    public static int getWFMPeriod(GregorianCalendar caldate, int nperiods) throws XMLSyntaxException {
        int wfmp;
        ArrayList<GregorianCalendar> periods = periodsmap.get(nperiods);
        switch (nperiods) {
            case 26: {
                wfmp = 14;
                break;
            }
            case 13: {
                wfmp = 7;
                break;
            }
            default: {
                throw new XMLSyntaxException("Allowed numbers of periods are 2 26 or 13");
            }
        }
        for (GregorianCalendar startperiod : periods) {
            if (!startperiod.before(caldate)) {
                return wfmp;
            }
            ++wfmp;
        }
        throw new XMLSyntaxException("Date is outside WFM period range");
    }

    private double numberOfHoursInPeriodWithPeriods(int per, int numPeriods) {
        int numPer = periodsmap.get(numPeriods).size();
        int offset = 0;
        switch (numPeriods) {
            case 26: {
                offset = 12;
                break;
            }
            case 13: {
                offset = 6;
                break;
            }
            case 2: {
                offset = 1;
                break;
            }
            default: {
                throw new Error("Allowed numbers of periods are 2 26 13");
            }
        }
        GregorianCalendar dstart = periodsmap.get(numPeriods).get(per += offset);
        GregorianCalendar dfinish = per > numPer - 2 ? periodsmap.get(numPeriods).get(offset) : periodsmap.get(numPeriods).get(per + 1);
        return WorkableHoursCalculator.workableHours(dstart.get(6), dfinish.get(6), this.getVariable(Types.VariableType.SOILTYPE), this.getVariable(Types.VariableType.RAINFALL));
    }

    private void refreshHoursCache() {
        for (int i = 0; i < this.hoursCache.length; ++i) {
            this.hoursCache[i] = this.numberOfHoursInPeriodWithPeriods(i, this.numPeriods);
            this.freeTimeHoursCache[i] = freeTimeHoursMap.get(this.numPeriods)[i];
        }
    }

    public double availableHours(int period) {
        return this.hoursCache[period];
    }

    public double availableFreeTimeHours(int period) {
        return this.freeTimeHoursCache[period];
    }

    public void setSoilType(double soil) {
        this.setVariable(Types.VariableType.SOILTYPE, soil);
        this.refreshHoursCache();
    }

    public void setRainFall(double rain) {
        this.setVariable(Types.VariableType.RAINFALL, rain);
        this.refreshHoursCache();
    }

    public void set(double sl, double rn) {
        this.setVariable(Types.VariableType.SOILTYPE, sl);
        this.setVariable(Types.VariableType.RAINFALL, rn);
        this.refreshHoursCache();
    }

    static {
        int i;
        freeTimeHoursMap = new HashMap();
        double[] hours26 = new double[]{80.0, 80.0, 80.0, 80.0, 85.0, 90.0, 100.0, 110.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 120.0, 110.0, 100.0, 90.0, 90.0, 90.0, 90.0, 90.0};
        double[] hours13 = new double[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            hours13[i2] = hours26[i2 * 2] + hours26[i2 * 2 + 1];
        }
        double[] hours2 = new double[]{1820.0, 1820.0};
        freeTimeHoursMap.put(26, hours26);
        freeTimeHoursMap.put(13, hours13);
        freeTimeHoursMap.put(2, hours2);
        hoursMap = new HashMap();
        hours26 = new double[26];
        hours13 = new double[13];
        hours2 = new double[2];
        hours26[0] = 0.0;
        hours26[1] = 0.0;
        hours26[2] = 0.0;
        hours26[3] = 0.7;
        hours26[4] = 20.0;
        hours26[5] = 47.8;
        hours26[6] = 75.7;
        hours26[7] = 103.5;
        hours26[8] = 118.4;
        hours26[9] = 118.4;
        hours26[10] = 118.4;
        hours26[11] = 118.4;
        hours26[12] = 118.4;
        hours26[13] = 118.4;
        hours26[14] = 118.4;
        hours26[15] = 117.3;
        hours26[16] = 114.5;
        hours26[17] = 100.0;
        hours26[18] = 86.1;
        hours26[19] = 72.3;
        hours26[20] = 58.4;
        hours26[21] = 44.6;
        hours26[22] = 30.7;
        hours26[23] = 16.9;
        hours26[24] = 3.6;
        hours26[25] = 0.0;
        for (i = 0; i < 13; ++i) {
            hours13[i] = hours26[2 * i] + hours26[2 * i + 1];
        }
        for (i = 0; i < 2; ++i) {
            hours2[i] = 0.0;
            for (int j = 0; j < 13; ++j) {
                int n = i;
                hours2[n] = hours2[n] + hours26[i * 13 + j];
            }
        }
        hoursMap.put(26, hours26);
        hoursMap.put(13, hours13);
        hoursMap.put(2, hours2);
        month = new HashMap();
        month.put("Jan", 0);
        month.put("Feb", 1);
        month.put("Mar", 2);
        month.put("Apr", 3);
        month.put("May", 4);
        month.put("Jun", 5);
        month.put("Jul", 6);
        month.put("Aug", 7);
        month.put("Sep", 8);
        month.put("Oct", 9);
        month.put("Nov", 10);
        month.put("Dec", 11);
        periods26 = new ArrayList();
        periods26.add(new GregorianCalendar(2000, month.get("Jul"), 16, 0, 0));
        periods26.add(new GregorianCalendar(2000, month.get("Jul"), 30, 0, 0));
        periods26.add(new GregorianCalendar(2000, month.get("Aug"), 13, 0, 0));
        periods26.add(new GregorianCalendar(2000, month.get("Aug"), 27, 0, 0));
        periods26.add(new GregorianCalendar(2000, month.get("Sep"), 10, 0, 0));
        periods26.add(new GregorianCalendar(2000, month.get("Sep"), 24, 0, 0));
        periods26.add(new GregorianCalendar(2000, month.get("Oct"), 8, 0, 0));
        periods26.add(new GregorianCalendar(2000, month.get("Oct"), 22, 0, 0));
        periods26.add(new GregorianCalendar(2000, month.get("Nov"), 5, 0, 0));
        periods26.add(new GregorianCalendar(2000, month.get("Nov"), 19, 0, 0));
        periods26.add(new GregorianCalendar(2000, month.get("Dec"), 3, 0, 0));
        periods26.add(new GregorianCalendar(2000, month.get("Dec"), 17, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Jan"), 1, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Jan"), 15, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Jan"), 29, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Feb"), 12, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Feb"), 26, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Mar"), 12, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Mar"), 26, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Apr"), 9, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Apr"), 23, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("May"), 7, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("May"), 21, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Jun"), 4, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Jun"), 18, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Jul"), 1, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Jul"), 16, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Jul"), 30, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Aug"), 13, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Aug"), 27, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Sep"), 10, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Sep"), 24, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Oct"), 8, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Oct"), 22, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Nov"), 5, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Nov"), 19, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Dec"), 3, 0, 0));
        periods26.add(new GregorianCalendar(2001, month.get("Dec"), 16, 0, 0));
        periods13 = new ArrayList();
        periods13.add(new GregorianCalendar(2000, month.get("Jul"), 16, 0, 0));
        periods13.add(new GregorianCalendar(2000, month.get("Aug"), 13, 0, 0));
        periods13.add(new GregorianCalendar(2000, month.get("Sep"), 10, 0, 0));
        periods13.add(new GregorianCalendar(2000, month.get("Oct"), 8, 0, 0));
        periods13.add(new GregorianCalendar(2000, month.get("Nov"), 5, 0, 0));
        periods13.add(new GregorianCalendar(2000, month.get("Dec"), 3, 0, 0));
        periods13.add(new GregorianCalendar(2001, month.get("Jan"), 1, 0, 0));
        periods13.add(new GregorianCalendar(2001, month.get("Jan"), 29, 0, 0));
        periods13.add(new GregorianCalendar(2001, month.get("Feb"), 26, 0, 0));
        periods13.add(new GregorianCalendar(2001, month.get("Mar"), 26, 0, 0));
        periods13.add(new GregorianCalendar(2001, month.get("Apr"), 23, 0, 0));
        periods13.add(new GregorianCalendar(2001, month.get("May"), 21, 0, 0));
        periods13.add(new GregorianCalendar(2001, month.get("Jun"), 18, 0, 0));
        periods13.add(new GregorianCalendar(2001, month.get("Jul"), 16, 0, 0));
        periods13.add(new GregorianCalendar(2001, month.get("Aug"), 13, 0, 0));
        periods13.add(new GregorianCalendar(2001, month.get("Sep"), 10, 0, 0));
        periods13.add(new GregorianCalendar(2001, month.get("Oct"), 8, 0, 0));
        periods13.add(new GregorianCalendar(2001, month.get("Nov"), 5, 0, 0));
        periods13.add(new GregorianCalendar(2001, month.get("Dec"), 3, 0, 0));
        periods2 = new ArrayList();
        periods2.add(new GregorianCalendar(2000, month.get("Jul"), 16, 0, 0));
        periods2.add(new GregorianCalendar(2001, month.get("Jan"), 15, 0, 0));
        periodsmap = new HashMap();
        periodsmap.put(26, periods26);
        periodsmap.put(13, periods13);
        periodsmap.put(2, periods2);
    }
}

