/*
 * Decompiled with CFR 0.152.
 */
package jfm.xml;

import java.util.Iterator;
import jfm.model.Crop;
import jfm.model.CropInput;
import jfm.model.Operation;
import jfm.model.Rotation;
import jfm.model.Types;
import jfm.xml.JFMObjectParser;
import jfm.xml.ObjectParser;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;

final class CropParser
extends JFMObjectParser {
    Types.CropType id;

    public CropParser(ObjectParser parent_) {
        this.parent = parent_;
        this.registerAttribute("yield", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("subsidy", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("price", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("id", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("disease", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("yield2", JFMObjectParser.optionalAttribute);
        this.registerAttribute("price2", JFMObjectParser.optionalAttribute);
        this.registerAttribute("prisk", JFMObjectParser.optionalAttribute);
        this.registerAttribute("yrisk", JFMObjectParser.optionalAttribute);
        this.registerAttribute("eostdev", JFMObjectParser.optionalAttribute);
        this.registerAttribute("fixedCostsApprox", JFMObjectParser.optionalAttribute);
        this.registerAttribute("yieldReduction", JFMObjectParser.optionalAttribute);
        this.registerAttribute("selfRotCost", JFMObjectParser.optionalAttribute);
        this.registerAttribute("allowContinuous", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("xml:base", JFMObjectParser.optionalAttribute);
    }

    public void initializeObject() throws XMLSyntaxException, XMLObjectException {
        Crop objalias;
        try {
            this.id = Types.xmlToCropType(this.getNamedAttribute("id"));
            Types.DiseaseType disease = Types.xmlToDiseaseType(this.getNamedAttribute("disease"));
            Rotation rotation = null;
            rotation = this.parserListExists("rotation") ? (Rotation)this.getParserList((String)"rotation").get((int)0).obj : new Rotation(this.id, null, null);
            objalias = new Crop(this.id, disease, rotation, Boolean.parseBoolean(this.getNamedAttribute("allowContinuous")));
            objalias.resetPrimaryYield(this.getNamedAttribute("yield"));
            objalias.resetSubsidy(Double.parseDouble(this.getNamedAttribute("subsidy")));
            objalias.resetPrimaryPrice(Double.parseDouble(this.getNamedAttribute("price")));
            if (this.attributeHasValue("prisk") || this.attributeHasValue("yrisk")) {
                if (!this.attributeHasValue("prisk") || !this.attributeHasValue("yrisk")) {
                    throw new Error("If prisk is defined then so must drisk and vice versa");
                }
                double pr = Double.parseDouble(this.getNamedAttribute("prisk"));
                double yr = Double.parseDouble(this.getNamedAttribute("yrisk"));
                objalias.resetPriceRisk(pr);
                objalias.resetYieldRisk(yr);
            }
            if (this.attributeHasValue("eostdev")) {
                objalias.resetEOStandardDeviation(Double.parseDouble(this.getNamedAttribute("eostdev")));
            }
            if (this.attributeHasValue("fixedCostsApprox")) {
                objalias.resetApproximateFixedCostsPerHectare(Double.parseDouble(this.getNamedAttribute("fixedCostsApprox")));
            }
            if (this.attributeHasValue("yieldReduction") || this.attributeHasValue("selfRotCost")) {
                int i;
                double[] yieldReductions = new double[]{0.0};
                double[] selfCosts = new double[]{0.0};
                if (!this.attributeHasValue("yieldReduction") || !this.attributeHasValue("selfRotCost")) {
                    throw new XMLSyntaxException("If yieldReduction is defined then selfRotCost must be also be defined with the same length");
                }
                String[] splitstr = this.getNamedAttribute("yieldReduction").split(",");
                yieldReductions = new double[splitstr.length + 1];
                yieldReductions[0] = 0.0;
                for (i = 0; i < splitstr.length; ++i) {
                    yieldReductions[i + 1] = Double.parseDouble(splitstr[i]);
                }
                splitstr = this.getNamedAttribute("selfRotCost").split(",");
                if (yieldReductions.length == splitstr.length + 1) {
                    selfCosts = new double[splitstr.length + 1];
                    selfCosts[0] = 0.0;
                    for (i = 0; i < splitstr.length; ++i) {
                        selfCosts[i + 1] = Double.parseDouble(splitstr[i]);
                    }
                } else {
                    throw new XMLSyntaxException("yieldReduction and selfRotCost must have the same length");
                }
                objalias.setSuccessiveRotationCosts(yieldReductions, selfCosts);
            }
            if (this.attributeHasValue("yield2") || this.attributeHasValue("price2")) {
                if (!this.attributeHasValue("yield2") || !this.attributeHasValue("price2")) {
                    throw new XMLSyntaxException("If yield2 is defined then price2 must also be defined");
                }
                objalias.resetSecondaryYield(this.getNamedAttribute("yield2"));
                objalias.resetSecondaryPrice(Double.parseDouble(this.getNamedAttribute("price2")));
            }
        }
        catch (NumberFormatException ex) {
            throw new XMLSyntaxException("A numerical value in the definition of " + this.id.xmlname + " cannot be parsed as numeric" + ex.getMessage());
        }
        catch (XMLSyntaxException ex) {
            throw new XMLSyntaxException(ex.getMessage());
        }
        if (this.parserListExists("operation")) {
            Iterator<ObjectParser> it = this.getParserList("operation").iterator();
            while (it.hasNext()) {
                objalias.addOperation((Operation)it.next().getObject());
            }
        }
        if (this.parserListExists("input")) {
            for (ObjectParser op : this.getParserList("input")) {
                CropInput ci = (CropInput)op.getObject();
                objalias.resetInput(ci.associatedVariable, ci);
            }
        }
        this.obj = objalias;
    }

    public String toString() {
        return "CropParser";
    }

    public String parsesNode() {
        return "crop";
    }

    public String name() {
        if (this.id != null) {
            return this.id.xmlname;
        }
        if (this.attributeHasValue("id")) {
            try {
                return this.getNamedAttribute("id");
            }
            catch (XMLObjectException ex) {
                throw new Error(ex.getMessage());
            }
        }
        return "crop";
    }

    protected boolean isPrimitive() {
        return false;
    }
}

