\name{wcgs}
\alias{wcgs}
\docType{data}
\title{
Western Collaborative Group Study
}
\description{
3154 healthy young men aged 39-59 from the San Francisco area were assessed for their personality type. All were free from coronary heart disease at the start of the research. Eight and a half years later change in this situation was recorded.
}
\usage{data(wcgs)}
\format{
  A data frame with 3154 observations on the following 13 variables.
  \describe{
    \item{\code{age}}{age in years}
    \item{\code{height}}{height in inches}
    \item{\code{weight}}{weight in pounds}
    \item{\code{sdp}}{systolic blood pressure in mm Hg}
    \item{\code{dbp}}{diastolic blood pressure in mm Hg}
    \item{\code{chol}}{Fasting serum cholesterol in mm \%}
    \item{\code{behave}}{behavior type which is a factor with levels \code{A1} \code{A2} \code{B3} \code{B4}}
    \item{\code{cigs}}{number of cigarettes smoked per day}
    \item{\code{dibep}}{behavior type a factor with levels \code{A}
      (Agressive) \code{B} (Passive)}
    \item{\code{chd}}{coronary heat disease developed is a factor with levels \code{no} \code{yes}}
    \item{\code{typechd}}{type of coronary heart disease is a factor with levels \code{angina} \code{infdeath} \code{none} \code{silent}}
    \item{\code{timechd}}{Time of CHD event or end of follow-up}
    \item{\code{arcus}}{arcus senilis is a factor with levels \code{absent} \code{present}}
  }
}
\details{
The WCGS began in 1960 with 3,524 male volunteers who were employed by 11 California companies. Subjects were 39 to 59 years old and free of heart disease as determined by electrocardiogram. After the initial screening, the study population dropped to 3,154 and the number of companies to 10 because of various exclusions. The cohort comprised both blue- and white-collar employees. At baseline the following information was collected: socio-demographic including age, education, marital status, income, occupation; physical and physiological including height, weight, blood pressure, electrocardiogram, and corneal arcus; biochemical including cholesterol and lipoprotein fractions; medical and family history and use of medications; behavioral data including Type A interview, smoking, exercise, and alcohol use. Later surveys added data on anthropometry, triglycerides, Jenkins Activity Survey, and caffeine use. Average follow-up continued for 8.5 years with repeat examinations
}
\source{
Statistics for Epidemiology by N. Jewell (2004)
}
\references{
Coronary Heart Disease in the Western Collaborative Group Study
Final Follow-up Experience of 8 1/2 Years
Ray H. Rosenman, MD; Richard J. Brand, PhD; C. David Jenkins, PhD; Meyer Friedman, MD; Reuben Straus, MD; Moses Wurm, MD
JAMA. 1975;233(8):872-877. doi:10.1001/jama.1975.03260080034016.
}
\examples{
data(wcgs)
## maybe str(wcgs) ; plot(wcgs) ...
}
\keyword{datasets}
