% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotAUCcurves.R
\name{plot_auc_precision_recall_curve}
\alias{plot_auc_precision_recall_curve}
\alias{plot_auc_precision_recall_curve,ANY-method}
\alias{plot_auc_precision_recall_curve,familiarCollection-method}
\title{Plot the precision-recall curve.}
\usage{
plot_auc_precision_recall_curve(
  object,
  draw = FALSE,
  dir_path = NULL,
  split_by = NULL,
  color_by = NULL,
  facet_by = NULL,
  facet_wrap_cols = NULL,
  ggtheme = NULL,
  discrete_palette = NULL,
  x_label = waiver(),
  y_label = waiver(),
  legend_label = waiver(),
  plot_title = waiver(),
  plot_sub_title = waiver(),
  caption = NULL,
  x_n_breaks = 5,
  x_breaks = NULL,
  y_n_breaks = 5,
  y_breaks = NULL,
  conf_int_style = c("ribbon", "step", "none"),
  conf_int_alpha = 0.4,
  width = waiver(),
  height = waiver(),
  units = waiver(),
  export_collection = FALSE,
  ...
)

\S4method{plot_auc_precision_recall_curve}{ANY}(
  object,
  draw = FALSE,
  dir_path = NULL,
  split_by = NULL,
  color_by = NULL,
  facet_by = NULL,
  facet_wrap_cols = NULL,
  ggtheme = NULL,
  discrete_palette = NULL,
  x_label = waiver(),
  y_label = waiver(),
  legend_label = waiver(),
  plot_title = waiver(),
  plot_sub_title = waiver(),
  caption = NULL,
  x_n_breaks = 5,
  x_breaks = NULL,
  y_n_breaks = 5,
  y_breaks = NULL,
  conf_int_style = c("ribbon", "step", "none"),
  conf_int_alpha = 0.4,
  width = waiver(),
  height = waiver(),
  units = waiver(),
  export_collection = FALSE,
  ...
)

\S4method{plot_auc_precision_recall_curve}{familiarCollection}(
  object,
  draw = FALSE,
  dir_path = NULL,
  split_by = NULL,
  color_by = NULL,
  facet_by = NULL,
  facet_wrap_cols = NULL,
  ggtheme = NULL,
  discrete_palette = NULL,
  x_label = waiver(),
  y_label = waiver(),
  legend_label = waiver(),
  plot_title = waiver(),
  plot_sub_title = waiver(),
  caption = NULL,
  x_n_breaks = 5,
  x_breaks = NULL,
  y_n_breaks = 5,
  y_breaks = NULL,
  conf_int_style = c("ribbon", "step", "none"),
  conf_int_alpha = 0.4,
  width = waiver(),
  height = waiver(),
  units = waiver(),
  export_collection = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{familiarCollection} object, or one or more \code{familiarData}
objects, that will be internally converted to a \code{familiarCollection} object.
It is also possible to provide a \code{familiarEnsemble} or one or more
\code{familiarModel} objects together with the data from which data is computed
prior to export. Paths to such files can also be provided.}

\item{draw}{(\emph{optional}) Draws the plot if TRUE.}

\item{dir_path}{(\emph{optional}) Path to the directory where the plots of receiver
operating characteristic curves are saved to. Output is saved in the
\code{performance} subdirectory. If \code{NULL} no figures are saved, but are returned
instead.}

\item{split_by}{(\emph{optional}) Splitting variables. This refers to column names
on which datasets are split. A separate figure is created for each split.
See details for available variables.}

\item{color_by}{(\emph{optional}) Variables used to determine fill colour of plot
objects. The variables cannot overlap with those provided to the \code{split_by}
argument, but may overlap with other arguments. See details for available
variables.}

\item{facet_by}{(\emph{optional}) Variables used to determine how and if facets of
each figure appear. In case the \code{facet_wrap_cols} argument is \code{NULL}, the
first variable is used to define columns, and the remaing variables are
used to define rows of facets. The variables cannot overlap with those
provided to the \code{split_by} argument, but may overlap with other arguments.
See details for available variables.}

\item{facet_wrap_cols}{(\emph{optional}) Number of columns to generate when facet
wrapping. If NULL, a facet grid is produced instead.}

\item{ggtheme}{(\emph{optional}) \code{ggplot} theme to use for plotting.}

\item{discrete_palette}{(\emph{optional}) Palette to use to color the different
plot elements in case a value was provided to the \code{color_by} argument.}

\item{x_label}{(\emph{optional}) Label to provide to the x-axis. If NULL, no label
is shown.}

\item{y_label}{(\emph{optional}) Label to provide to the y-axis. If NULL, no label
is shown.}

\item{legend_label}{(\emph{optional}) Label to provide to the legend. If NULL, the
legend will not have a name.}

\item{plot_title}{(\emph{optional}) Label to provide as figure title. If NULL, no
title is shown.}

\item{plot_sub_title}{(\emph{optional}) Label to provide as figure subtitle. If
NULL, no subtitle is shown.}

\item{caption}{(\emph{optional}) Label to provide as figure caption. If NULL, no
caption is shown.}

\item{x_n_breaks}{(\emph{optional}) Number of breaks to show on the x-axis of the
plot. \code{x_n_breaks} is used to determine the \code{x_breaks} argument in case it
is unset.}

\item{x_breaks}{(\emph{optional}) Break points on the x-axis of the plot.}

\item{y_n_breaks}{(\emph{optional}) Number of breaks to show on the y-axis of the
plot. \code{y_n_breaks} is used to determine the \code{y_breaks} argument in case it
is unset.}

\item{y_breaks}{(\emph{optional}) Break points on the y-axis of the plot.}

\item{conf_int_style}{(\emph{optional}) Confidence interval style. See details for
allowed styles.}

\item{conf_int_alpha}{(\emph{optional}) Alpha value to determine transparency of
confidence intervals or, alternatively, other plot elements with which the
confidence interval overlaps. Only values between 0.0 (fully transparent)
and 1.0 (fully opaque) are allowed.}

\item{width}{(\emph{optional}) Width of the plot. A default value is derived from
the number of facets.}

\item{height}{(\emph{optional}) Height of the plot. A default value is derived from
the number of features and the number of facets.}

\item{units}{(\emph{optional}) Plot size unit. Either \code{cm} (default), \code{mm} or \verb{in}.}

\item{export_collection}{(\emph{optional}) Exports the collection if TRUE.}

\item{...}{
  Arguments passed on to \code{\link[=as_familiar_collection]{as_familiar_collection}}, \code{\link[ggplot2:ggsave]{ggplot2::ggsave}}
  \describe{
    \item{\code{familiar_data_names}}{Names of the dataset(s). Only used if the \code{object} parameter
is one or more \code{familiarData} objects.}
    \item{\code{collection_name}}{Name of the collection.}
    \item{\code{filename}}{File name to create on disk.}
    \item{\code{plot}}{Plot to save, defaults to last plot displayed.}
    \item{\code{device}}{Device to use. Can either be a device function
(e.g. \link{png}), or one of "eps", "ps", "tex" (pictex),
"pdf", "jpeg", "tiff", "png", "bmp", "svg" or "wmf" (windows only).}
    \item{\code{path}}{Path of the directory to save plot to: \code{path} and \code{filename}
are combined to create the fully qualified file name. Defaults to the
working directory.}
    \item{\code{scale}}{Multiplicative scaling factor.}
    \item{\code{dpi}}{Plot resolution. Also accepts a string input: "retina" (320),
"print" (300), or "screen" (72). Applies only to raster output types.}
    \item{\code{limitsize}}{When \code{TRUE} (the default), \code{ggsave()} will not
save images larger than 50x50 inches, to prevent the common error of
specifying dimensions in pixels.}
    \item{\code{bg}}{Background colour. If \code{NULL}, uses the \code{plot.background} fill value
from the plot theme.}
  }}
}
\value{
\code{NULL} or list of plot objects, if \code{dir_path} is \code{NULL}.
}
\description{
This method creates precision-recall curves based on data in a
familiarCollection object.
}
\details{
This function generates area under the precision-recall curve plots.

Available splitting variables are: \code{fs_method}, \code{learner}, \code{data_set} and
\code{positive_class}. By default, the data is split by \code{fs_method} and \code{learner},
with faceting by \code{data_set} and colouring by \code{positive_class}.

Available palettes for \code{discrete_palette} are those listed by
\code{grDevices::palette.pals()} (requires R >= 4.0.0), \code{grDevices::hcl.pals()}
(requires R >= 3.6.0) and \code{rainbow}, \code{heat.colors}, \code{terrain.colors},
\code{topo.colors} and \code{cm.colors}, which correspond to the palettes of the same
name in \code{grDevices}. If not specified, a default palette based on palettes
in Tableau are used. You may also specify your own palette by using colour
names listed by \code{grDevices::colors()} or through hexadecimal RGB strings.

Bootstrap confidence intervals of the ROC curve (if present) can be shown
using various styles set by \code{conf_int_style}:
\itemize{
\item \code{ribbon} (default): confidence intervals are shown as a ribbon with an
opacity of \code{conf_int_alpha} around the point estimate of the ROC curve.
\item \code{step} (default): confidence intervals are shown as a step function around
the point estimate of the ROC curve.
\item \code{none}: confidence intervals are not shown. The point estimate of the ROC
curve is shown as usual.
}

Labelling methods such as \code{set_fs_method_names} or \code{set_data_set_names} can
be applied to the \code{familiarCollection} object to update labels, and order
the output in the figure.
}
