% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_metric.R
\name{group_metric}
\alias{group_metric}
\title{Group metric}
\usage{
group_metric(
  x,
  fairness_metric = NULL,
  performance_metric = NULL,
  parity_loss = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{object of class \code{fairness_object}}

\item{fairness_metric}{character, fairness metric name}

\item{performance_metric}{character, performance metric name}

\item{parity_loss}{logical, if \code{TRUE} parity loss will supersede basic metric}

\item{verbose}{logical, whether to print information about metrics on console or not. Default \code{TRUE}}
}
\value{
\code{group_metric} object.
It is a list with following items:
\itemize{
\item{group_metric_data}{ - \code{data.frame} containing fairness metric scores for each model}
\item{performance_data}{ - \code{data.frame} containing performance metric scores for each model}
\item{fairness_metric}{ - name of fairness metric}
\item{performance_metric}{ - name of performance metric}

}
}
\description{
Group metric enables to extract data from metrics generated for each subgroup (values in protected variable)
The closer metric values are to each other, the less bias particular model has. If \code{parity_loss} parameter is set to \code{TRUE}, distance between
privileged and unprivileged subgroups will be measured. When plotted shows both fairness metric and chosen performance metric.
}
\details{
Available metrics:

Fairness metrics:

\itemize{
\item TPR
\item TNR
\item PPV
\item NPV
\item FNR
\item FPR
\item FDR
\item FOR
\item TS
\item ACC
\item F1
}
Performance metrics

\itemize{
\item recall
\item precision
\item accuracy
\item f1
\item auc
}
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           num.trees = 200)

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = german$Sex,
                          privileged = "male")

gm <- group_metric(fobject, "TPR", "f1", parity_loss = TRUE)

plot(gm)

}
