% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ror.R
\name{estimate_ror_bygroup}
\alias{estimate_ror_bygroup}
\title{Estimate Measures of Association}
\usage{
estimate_ror_bygroup(
  tabular_faers_data,
  group_of_interest_col = NULL,
  group_of_interest_ref = NULL,
  rename_vector = NULL,
  event_of_interest_col = NULL,
  ...
)
}
\arguments{
\item{tabular_faers_data}{FAERS tabular format. Output of function \link{retrieve_faersxml} or \link{retrieve_faersxml_all}}

\item{group_of_interest_col}{a string, specifying the group of interest. 
Must me a column name of `tabular_faers_data`, and this columns should only contain two unique values.}

\item{group_of_interest_ref}{a string, specifying the group of interest reference. Must me a value from the group of interest column.}

\item{rename_vector}{optional. named vector to rename the group of interest, in order to show up in a}

\item{event_of_interest_col}{a string, specifying the event of interest. Must me a column name of `tabular_faers_data`.}

\item{...}{arguments passed to `estimate_ror` like `ic_range`.}
}
\value{
tibble with the event of interest counts, group of interest counts and the respective estimated measures of association 
(ROR and its IC, PRR and its IC, Information Component and Chi-squared statisti with Yates correction.
}
\description{
Estimate Measures of Association
}
\examples{
estimate_ror_bygroup(tabular_faers_data = dplyr::filter(als_faers_data_unified, 
sex \%in\% c("M", "F")),
group_of_interest_col = "sex", 
group_of_interest_ref = "M", 
event_of_interest_col = "pt") 


}
