# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title VaultDateParameters
#' @description VaultDateParameters Class
#' @format An \code{R6Class} generator object
#' @field startdate  character [optional]
#'
#' @field enddate  character 
#'
#' @field frequency  character 
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
VaultDateParameters <- R6::R6Class(
  'VaultDateParameters',
  public = list(
    `startdate` = NULL,
    `enddate` = NULL,
    `frequency` = NULL,
    initialize = function(`enddate`, `frequency`, `startdate`=NULL, ...){
      local.optional.var <- list(...)
      if (!missing(`enddate`)) {
        stopifnot(is.character(`enddate`), length(`enddate`) == 1)
        self$`enddate` <- `enddate`
      }
      if (!missing(`frequency`)) {
        stopifnot(is.character(`frequency`), length(`frequency`) == 1)
        self$`frequency` <- `frequency`
      }
      if (!is.null(`startdate`)) {
        stopifnot(is.character(`startdate`), length(`startdate`) == 1)
        self$`startdate` <- `startdate`
      }
    },
    toJSON = function() {
      VaultDateParametersObject <- list()
      if (!is.null(self$`startdate`)) {
        VaultDateParametersObject[['startdate']] <-
          self$`startdate`
      }
      if (!is.null(self$`enddate`)) {
        VaultDateParametersObject[['enddate']] <-
          self$`enddate`
      }
      if (!is.null(self$`frequency`)) {
        VaultDateParametersObject[['frequency']] <-
          self$`frequency`
      }

      VaultDateParametersObject
    },
    fromJSON = function(VaultDateParametersJson) {
      VaultDateParametersObject <- jsonlite::fromJSON(VaultDateParametersJson)
      if (!is.null(VaultDateParametersObject$`startdate`)) {
        self$`startdate` <- VaultDateParametersObject$`startdate`
      }
      if (!is.null(VaultDateParametersObject$`enddate`)) {
        self$`enddate` <- VaultDateParametersObject$`enddate`
      }
      if (!is.null(VaultDateParametersObject$`frequency`)) {
        self$`frequency` <- VaultDateParametersObject$`frequency`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`startdate`)) {
        sprintf(
        '"startdate":
          "%s"
                ',
        self$`startdate`
        )},
        if (!is.null(self$`enddate`)) {
        sprintf(
        '"enddate":
          "%s"
                ',
        self$`enddate`
        )},
        if (!is.null(self$`frequency`)) {
        sprintf(
        '"frequency":
          "%s"
                ',
        self$`frequency`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(VaultDateParametersJson) {
      VaultDateParametersObject <- jsonlite::fromJSON(VaultDateParametersJson)
      self$`startdate` <- VaultDateParametersObject$`startdate`
      self$`enddate` <- VaultDateParametersObject$`enddate`
      self$`frequency` <- VaultDateParametersObject$`frequency`
      self
    }
  )
)
