% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_fsvdraws.R
\name{signident}
\alias{signident}
\title{A posteriori sign identification}
\usage{
signident(x, method = "maximin", implementation = 3)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{method}{Can be "diagonal" or "maximin". If "diagonal" is
chosen, the diagonal elements of the factor loadings matrix
are assumed to have positive signs
and the others are arranged accordingly.
If "maximin" is chosen, for each factor, \code{signident} looks
for the series where
the minimum absolute loadings are biggest and chooses this series
to have positive loadings.}

\item{implementation}{Either 1, 2, or 3 (the default). Determines
how the reordering is implemented. Should not be necessary to depart
from the default.}
}
\value{
Returns an object of class \code{'fsvdraws'} with adjusted
factors and factor loadings. Moreover, a list element called
\code{'identifier'} is added, providing the numbers of the series
used for identification and the corresponding minimum distances to
zero.
}
\description{
\code{signident} provides methods for identifying the signs of
the factor loadings after running the MCMC sampler
}
\examples{
\dontrun{
set.seed(1)
sim <- fsvsim(series = 8, factors = 2) # simulate 
res <- fsvsample(sim$y, factors = 2, signswitch = TRUE,
                 draws = 2000, burnin = 1000) # estimate

# Plot unidentified loadings:
facloaddensplot(res, fsvsimobj = sim, rows = 8)

# Identify:
res <- signident(res)

# Plot identified loadings:
facloaddensplot(res, fsvsimobj = sim, rows = 8)
}

}
\seealso{
Other postprocessing: \code{\link{orderident}}
}

