% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_other.R
\name{findrestrict}
\alias{findrestrict}
\title{Ad-hoc method for (weakly) identifying the factor
loadings matrix}
\usage{
findrestrict(dat, factors, transload = abs, relto = "all")
}
\arguments{
\item{dat}{Matrix containing the data, with \code{n} rows
(points in time) and \code{m} columns (component series).}

\item{factors}{Number of factors to be used.}

\item{transload}{Function for transforming the estimated
factor loadings before ordering. Defaults to the absolute value
function.}

\item{relto}{Can be 'none', 'current' or 'all'. If 'none', the series
with the highest loadings is placed first, the series with the second
highest is placed second, and so on.
If 'current', the current factor loading is used as a reference, if 'all',
all previous loadings are summed up to be the reference.}
}
\value{
A \code{m} times \code{factors} matrix indicating
the restrictions.
}
\description{
In factor SV models, the identification of the factor loadings
matrix is often
chosen through a preliminary static factor analysis. 
After a maximum likelihood factor model is fit to the data,
variables are ordered as follows: The variable with the
lowest loadings on all factors except the first (relative to
it) is determined to lead the first factor,
the variable with the lowest loadings on all factors except the
first two (relative to these) is determined to lead the second
factor, etc.
}
\note{
This function is automatically invoked by fsvsample if
restrict is set to 'auto'.
}
\seealso{
ledermann
}
