% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic-syntax.R
\name{factorH_syntax}
\alias{factorH_syntax}
\alias{factorH-syntax}
\alias{syntax.factorH}
\title{Syntax and formula patterns}
\description{
Syntax and formula patterns
}
\details{
\subsection{Formula syntax at a glance}{

All high-level functions use standard R \strong{model formulas}:
response ~ factorA + factorB + factorC
\itemize{
\item + lists \strong{main effects} - Interactions are handled internally. You
do \code{not} need to write A:B or A*B.
\item The \code{response} (left of ~) must be \code{numeric} (e.g., a Likert score
coded as 1..5 stored as numeric).
}

Examples below use the included dataset mimicry.

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(factorH)
data(mimicry, package = "factorH")
str(mimicry)
}\if{html}{\out{</div>}}

Predictors should be factors. If not, functions will coerce them.

\strong{What is allowed?}

\if{html}{\out{<div class="sourceCode">}}\preformatted{# One factor (KW-style):  
  liking ~ condition

# Two factors (SRH-style):  
  liking ~ gender + condition

# Three or more factors (k-way):  
  liking ~ gender + condition + age_cat
}\if{html}{\out{</div>}}

You do \code{not} need to write gender:condition or gender*condition. The
package will build all needed interactions internally when relevant.
}

\subsection{Numeric response (Likert note)}{

The response must be \code{numeric}. For Likert-type items (e.g., 1 =
strongly disagree … 5 = strongly agree), keep them numeric; rank-based
tests are robust for such \code{ordinal-like} data.

If your Likert is accidentally a \code{factor} or \code{character}, coerce safely:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# if stored as character "1","2",...:
mimicry$liking <- as.numeric(mimicry$liking)
# if stored as factor with labels "1","2",...:
mimicry$liking <- as.numeric(as.character(mimicry$liking))
}\if{html}{\out{</div>}}
}
}
