% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_pAMCE.R
\name{design_pAMCE}
\alias{design_pAMCE}
\title{Estimating the population AMCE using a design-based approach}
\usage{
design_pAMCE(formula, factor_name, data, pair = FALSE, pair_id = NULL,
  cross_int = FALSE, cluster_id = NULL, target_dist, target_type,
  partial_joint_name)
}
\arguments{
\item{formula}{Formula}

\item{factor_name}{Factors for which the function estimates the pAMCEs. If not specified, the function estimates for all factors.}

\item{data}{Data}

\item{pair}{Whether we use a paired-choice conjoint design.}

\item{pair_id}{Unique identifiers for pairs in the paired-choice conjoint design  (optional).}

\item{cross_int}{Include interactions across profiles. Default is FALSE.}

\item{cluster_id}{Unique identifiers for computing cluster standard errors (optional).}

\item{target_dist}{Target profile distributions to be used. See Examples in the GitHub page for details.}

\item{target_type}{Types of target profile distributions. `marginal`, 'partial_joint', or `target_data`.}

\item{partial_joint_name}{(when `target_type = "partial_joint"`) Names of factors representing partial joint distributions. See Examples in the GitHub page for details.}
}
\value{
\code{design_pAMCE} returns an object of \code{pAMCE} class.
 \itemize{
   \item \code{AMCE}: Estimates of the pAMCE for all factors.
   \item \code{design_weight}: Weight for each observation used in the weighted difference-in-means.
   \item \code{approach}: "design_based"
   \item \code{input}: Input into the function.
   \item \code{...}: Values for internal use.
 }
}
\description{
\code{design_pAMCE} implements the design-based approach to estimate the pAMCE. See de la Cuesta, Egami, and Imai (2019+) for details. More examples are available at the GitHub page of \code{factorEx}.
}
\examples{
# Small example
data("OnoBurden")
OnoBurden_data_pr_s <- OnoBurden$OnoBurden_data_pr[1:500, ]
# randomization based on marginal population design
target_dist_marginal_s <- OnoBurden$target_dist_marginal[c("gender", "age")]

# design-based estimation
out_design_mar_s <-
  design_pAMCE(formula = Y ~ gender + age,
               factor_name = "gender",
               data = OnoBurden_data_pr_s,
               pair_id = OnoBurden_data_pr_s$pair_id,
               cluster_id = OnoBurden_data_pr_s$id,
               target_dist  = target_dist_marginal_s, target_type = "marginal")
summary(out_design_mar_s)
\donttest{
  #  Example
  data("OnoBurden")
  OnoBurden_data_pr <- OnoBurden$OnoBurden_data_pr
  # randomization based on marginal population design
  target_dist_marginal <- OnoBurden$target_dist_marginal

  # design-based estimation
  out_design_mar <-
    design_pAMCE(formula = Y ~ gender + age + family + race + experience + party + pos_security,
                 factor_name = c("gender", "age", "experience"),
                 data = OnoBurden_data_pr,
                 pair_id = OnoBurden_data_pr$pair_id,
                 cluster_id = OnoBurden_data_pr$id,
                 target_dist  = target_dist_marginal, target_type = "marginal")
 summary(out_design_mar)
}
}
\references{
de la Cuesta, Egami, and Imai. (2019+). Improving the External Validity of Conjoint Analysis: The Essential Role of Profile Distribution. (Working Paper). Available at \url{https://scholar.princeton.edu/sites/default/files/negami/files/conjoint_profile.pdf}.

Egami and Imai. (2019). Causal Interaction in Factorial Experiments: Application to Conjoint Analysis. Journal of the American Statistical Association, Vol.114, No.526 (June), pp. 529–540. Available at \url{https://scholar.princeton.edu/sites/default/files/negami/files/causalint.pdf}.
}
