% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_famd.R
\name{get_famd}
\alias{get_famd}
\alias{get_famd_ind}
\alias{get_famd_var}
\title{Extract the results for individuals and variables - FAMD}
\usage{
get_famd(res.famd, element = c("ind", "var", "quanti.var", "quali.var"))

get_famd_ind(res.famd)

get_famd_var(res.famd, element = c("var", "quanti.var", "quali.var"))
}
\arguments{
\item{res.famd}{an object of class FAMD [FactoMineR].}

\item{element}{the element to subset from the output. Possible values are "ind", "quanti.var" or "quali.var".}
}
\value{
a list of matrices containing the results for the active 
individuals and variables, including : 
\item{coord}{coordinates of indiiduals/variables.}
\item{cos2}{cos2 values representing the quality of representation on the factor map.}
\item{contrib}{contributions of individuals / variables to the principal components.}
}
\description{
Extract all the results (coordinates, squared cosine and contributions) 
for the active individuals and variables from Factor Analysis of Mixed Date (FAMD) outputs.\cr\cr
\itemize{
\item get_famd(): Extract the results for variables and individuals
\item get_famd_ind(): Extract the results for individuals only
\item get_famd_var(): Extract the results for quantitative and qualitative variables only
}
}
\examples{

 # Compute FAMD
 library("FactoMineR")
 data(wine)
 res.famd <- FAMD(wine[,c(1,2, 16, 22, 29, 28, 30,31)], graph = FALSE)
 
 # Extract the results for qualitative variable categories
 quali.var <- get_famd_var(res.famd, "quali.var")
 print(quali.var)
 head(quali.var$coord) # coordinates of qualitative variables
 
 # Extract the results for quantitative variables
 quanti.var <- get_famd_var(res.famd, "quanti.var")
 print(quanti.var)
 head(quanti.var$coord) # coordinates
 
 # Extract the results for individuals
 ind <- get_famd_ind(res.famd)
 print(ind)
 head(ind$coord) # coordinates of individuals
 
 
}
\author{
Alboukadel Kassambara \email{alboukadel.kassambara@gmail.com}
}

