% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FacebookLikesCollection-class.R
\docType{class}
\name{FacebookLikesCollection-class}
\alias{FacebookLikesCollection-class}
\title{Class for representing a Collection of Facebook likes}
\description{
This class is used to collect Facebook likes in a convenient structure.

Use the \code{\link{FacebookLikesCollection}} constructor for building a instance of this class, as it provides better
sanity and validation checks.
}
\details{
Although they are named the same in the Facebook jargon, likes to posts or comments are different to users' likes.
This collection covers the first, while the \code{\link{facebook.object.likes}} the latter.
}
\section{Slots}{

\describe{
\item{\code{data}}{The raw data in a list form and as pulled from Facebook}

\item{\code{id}}{A character vector with the \code{id} of the items included in the collection}

\item{\code{fields}}{A character vector with the fields included for each ID in the collection. Ie. \code{id, name, created_time}...}

\item{\code{token}}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{fbOAuth} used to fill the collection.}

\item{\code{parent}}{A character vector of the parent \code{id} of the items included in the collection or \code{NA} if the items have
no valid inheritance}

\item{\code{parent.collection}}{The collection used to build this one, or \code{NA} if the collection was built from a character vectors of \code{ids}.}

\item{\code{type}}{A character vector with the type of each element of the collection. It's set only if the collection has been built with \code{metadata=TRUE}}
}}

\seealso{
\code{\link{facebook.object.likes}}

Other Facebook Collections: \code{\link{FacebookAlbumsCollection-class}},
  \code{\link{FacebookCommentsCollection-class}},
  \code{\link{FacebookConversationsCollection-class}},
  \code{\link{FacebookEventsCollection-class}},
  \code{\link{FacebookGenericCollection-class}},
  \code{\link{FacebookGroupsCollection-class}},
  \code{\link{FacebookMessagesCollection-class}},
  \code{\link{FacebookMixedCollection-class}},
  \code{\link{FacebookPagesCollection-class}},
  \code{\link{FacebookPhotosCollection-class}},
  \code{\link{FacebookPostsCollection-class}},
  \code{\link{FacebookReactionsCollection-class}},
  \code{\link{FacebookVideosCollection-class}}
}
\author{
Gabriele Baldassarre \url{https://gabrielebaldassarre.com}
}
