% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{residuals.VAR}
\alias{residuals.VAR}
\title{Extract residuals from a fable model}
\usage{
\method{residuals}{VAR}(object, ...)
}
\arguments{
\item{object}{The time series model used to produce the forecasts}

\item{...}{Additional arguments for forecast model methods.}
}
\value{
A vector of fitted residuals.
}
\description{
Extracts the residuals.
}
\examples{
lung_deaths <- cbind(mdeaths, fdeaths) \%>\%
  as_tsibble(pivot_longer = FALSE)

lung_deaths \%>\%
  model(VAR(vars(mdeaths, fdeaths) ~ AR(3))) \%>\%
  residuals()
}
