% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fable_ata.R
\name{AutoATA}
\alias{AutoATA}
\title{ATAforecasting: Automatic Time Series Analysis and Forecasting using Ata Method with Box-Cox Power Transformations Family and Seasonal Decomposition Techniques}
\usage{
AutoATA(formula, ...)
}
\arguments{
\item{formula}{Model specification (see "Specials" section).}

\item{...}{Other arguments}
}
\value{
A model specification.
}
\description{
Returns ATA(p,q,phi)(E,T,S) applied to time series data.
The Ata method based on the modified simple exponential smoothing as described in Yapar, G. (2016) <doi:10.15672/HJMS.201614320580> ,
Yapar G., Capar, S., Selamlar, H. T., Yavuz, I. (2017) <doi:10.15672/HJMS.2017.493> and Yapar G., Selamlar, H. T., Capar, S., Yavuz, I. (2019)
<doi:10.15672/hujms.461032> is a new univariate time series forecasting method which provides innovative solutions to issues faced during
the initialization and optimization stages of existing methods.
Forecasting performance of the Ata method is superior to existing methods both in terms of easy implementation and accurate forecasting.
It can be applied to non-seasonal or seasonal time series which can be decomposed into four components (remainder, level, trend and seasonal).
This methodology performed well on the M3 and M4-competition data.
}
\section{Specials}{


The _specials_ define the methods and parameters for the components (level, trend, seasonality, accuracy, transform, holdout) of an ATA method.

There are a couple of limitations to note about ATA method:

- It supports only additive error term.
- It does not support exogenous regressors.
- It does not support missing values. You can complete missing values in the data with imputed values (e.g. with [tsibble::fill_gaps()], [tidyr::fill()], or by fitting a different model type and then calling [fabletools::interpolate()]) before fitting the model.

\subsection{level}{
The `level` special is used to specify the form of the level term.
\preformatted{
level(parP = NULL, level_fixed = TRUE, initial_level = FALSE)
}

\tabular{ll}{
  `parP`     \tab The value of the smoothing parameter for the level. If `p = 0`, the level will not change over time. Conversely, if `p = 1` the level will update similarly to a random walk process. If NULL or "opt", it is estimated. \code{p} has all integer values from 1 to \code{length(data)}. \cr
  `level_fixed`      \tab If TRUE, "pStarQ"  --> First, fits ATA(p,0) where p = p* is optimized for q=0. Then, fits ATA(p*,q) where q is optimized for p = p*. \cr
  `initial_level`     \tab If NULL, FALSE is default. If FALSE, ATA Method calculates the pth observation in \code{data} for level. If TRUE, ATA Method calculates average of first p value in \code{data}for level. \cr

}
}

\subsection{trend}{
The `trend` special is used to specify the form of the trend term and associated parameters.
\preformatted{
trend(type = "A", parQ = NULL, initial_trend = FALSE, opt_trend = "none",
       parPHI = NULL, parPHI_range = c(0.8, 1.0), parPHI_increment = 0.01,
       uroot_test = "adf", uroot_alpha = 0.05, uroot_type = "level")
}

\tabular{ll}{
  `type`     \tab The form of the trend term: either none ("N"), additive ("A"), multiplicative ("M") or damped variants ("Ad", "Md"). \cr
  `parQ`      \tab The value of the smoothing parameter for the slope. If `q = 0`, the slope will not change over time. Conversely, if `q = 1` the slope will have mean of past slopes. \cr
  `parPHI` \tab The value of the dampening parameter for the slope. If `phi = 0`, the slope will be dampened immediately (no slope). Conversely, if `phi = 1` the slope will not be dampened. \cr
  `parPHI_range`       \tab If `phi=NULL`, `phi_range` provides bounds for the optimised value of `phi`.\cr
  `parPHI_increment`  \tab If `phi=NULL`, `parPHI_increment` provides increment step for searching `phi`. If NULL, `parPHI_increment` will be determined as the value that allows the `parPHI_range` to be divided into 20 equal parts. \cr
  `initial_trend`        \tab If NULL, FALSE is default. If FALSE, ATA Method calculates the qth observation in \code{X(T)-X(T-1)} for trend. If TRUE, ATA Method calculates average of first q value in \code{X(T)-X(T-1)} for trend. \cr
  `trend_opt`        \tab Default is `none`. If `fixed` is set, "pBullet" --> Fits ATA(p,1) where p = p* is optimized for q = 1. If `search` is set "qBullet" --> Fits ATA(p,q) where p = p* is optimized for q = q* (q > 0). Then, fits ATA(p*,q) where q is optimized for p = p*. \cr
  `uroot_test`        \tab Type of unit root test before all type seasonality test. Possible values are "adf", "pp" and "kpss". \cr
  `uroot_alpha`   \tab Significant level of the unit root test, possible values range from 0.01 to 0.1. \cr
  `uroot_type`        \tab Specification of the deterministic component in the regression for unit root test. Possible values are "level" and "trend". \cr
  `uroot_maxd`       \tab Maximum number of non-seasonal differences allowed. \cr
}
}

\subsection{season}{
The `season` special is used to specify the form of the seasonal term and associated parameters. To specify a nonseasonal model you would include `season(method = "N")`.
\preformatted{
season(type = "A", test = TRUE, period = NULL, method = "decomp",
       suroot_test = "correlogram", suroot_tcrit = 1.28, suroot_uroot = TRUE, suroot_m = NULL)
}
\tabular{ll}{
  `type`     \tab The form of the seasonal term: either none ("N"), additive ("A") or multiplicative ("M"). \cr
  `test`     \tab Testing for stationary and seasonality. If TRUE, the method firstly uses \code{test="adf"}, Augmented Dickey-Fuller, unit-root test then the test returns the least number of differences required to pass the test at level \code{alpha}. After the unit-root test, seasonal test applies on the stationary \code{data}. \cr
  `period`     \tab The periodic nature of the seasonality. This can be a number indicating the number of observations in each seasonal period (for example, annual seasonality would be "1").  \cr
  `method`      \tab A string identifying method for seasonal decomposition. If NULL, "decomp" method is default. Possible values are c("none", "decomp", "stl", "stlplus", "tbats", "stR") phrases of methods denote. \cr
  `suroot_test`     \tab Type of seasonal unit root test to use. Possible values are "correlogram", "seas", "hegy", "ch" and "ocsb". \cr
  `suroot_tcrit`     \tab t-value for autocorrelogram.  \cr
  `suroot_alpha`     \tab Significant level of the seasonal unit root test, possible values range from 0.01 to 0.1.  \cr
  `suroot_uroot`     \tab If TRUE, unit root test for stationary before seasonal unit root test is allowed. \cr
  `suroot_m`      \tab Deprecated. Length of seasonal period: frequency of data for nsdiffs. \cr
  `suroot_maxD`     \tab Maximum number of seasonal differences allowed. \cr
}
}

\subsection{accuracy}{
The `accuracy` special is used to the optimization criterion for selecting the best ATA Method forecasting.
\preformatted{
accuracy(criteria = "sMAPE", nmse = 3, ic = "AIC")
}

\tabular{ll}{
  `criteria`     \tab Accuracy measure for optimization of the best ATA Method forecasting. IF NULL, `sMAPE` is default. \cr
  `nmse`     \tab If `accuracy.type == "AMSE"`, `nmse` provides the number of steps for average multistep MSE `(2<=nmse<=30)`. \cr
  `ic`     \tab The information criterion used in selecting the model.  \cr
}
}

\subsection{transform}{
The `transform` special is used to provide the applicability of different types of transformation techniques for the data to which the ATA method will be applied.
\preformatted{
transform(method="none", order = "none", lambda = NULL, shift = 0,
          bcMethod = "guerrero", bcLower = 0, bcUpper = 5)
}

\tabular{ll}{
  `method`     \tab Transformation method  --> "Box_Cox", "Sqrt", "Reciprocal", "Log", "NegLog", "Modulus", "BickelDoksum", "Manly", "Dual", "YeoJohnson", "GPower", "GLog". If the transformation process needs shift parameter, it will be calculated required shift parameter automatically. \cr
  `order`     \tab Default is "none. If "before", Box-Cox transformation family will be applied and then seasonal decomposition techniques will be applied. If "after", seasonal decomposition techniques will be applied and then Box-Cox transformation family will be applied. \cr
  `lambda`     \tab Box-Cox power transformation family parameter. If NULL, data transformed before model is estimated.  \cr
  `shift`     \tab Box-Cox power transformation family shifting parameter. If NULL, data transformed before model is estimated. \cr
  `bcMethod`     \tab Choose method to be used in calculating lambda. "guerrero" is default. Other method is "loglik". \cr
  `bcLower`     \tab Lower limit for possible lambda values. The lower value is limited by -5. Default value is 0. \cr
  `bcUpper`     \tab Upper limit for possible lambda values. The upper value is limited by 5. Default value is 5. \cr
}
}

\subsection{holdout}{
The `holdout` special is used to improve the optimized parameter value obtained for the ATA Method forecasting.
\preformatted{
holdout(holdout = FALSE, adjustment = TRUE, set_size = NULL)
}

\tabular{ll}{
  `holdout`     \tab Default is FALSE. If TRUE, ATA Method uses the holdout forecasting for accuracy measure to select the best parameter set. In holdout forecasting, this parameter divides `data` into two parts: training set (in-sample) and validation set (holdout set). \cr
  `adjustment`     \tab Default is TRUE. If TRUE, `parP` will be adjusted by length of training, validation sets and main data set when the holdout forecasting is active. \cr
  `set_size`     \tab If `holdout` is TRUE, this parameter divides `data` into two parts: training set (in-sample) and validation set (holdout set). Also, this parameter will be same as `h` for defining holdout set.  \cr
}
}
}

\examples{
library(fable.ata)
as_tsibble(USAccDeaths) \%>\% model(ata = AutoATA(value ~ trend("A") + season("A")))

}
