% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer_format_ifti.R
\name{infer_format_ifti_vec}
\alias{infer_format_ifti_vec}
\title{Infer fMRI data format for several inputs}
\usage{
infer_format_ifti_vec(BOLD, verbose = FALSE)
}
\arguments{
\item{BOLD}{The vector of fMRI data, expected to be of one format}

\item{verbose}{Print the format? Default: \code{FALSE}.}
}
\value{
A length-two vector. The first element indicates the format:
\code{"CIFTI"} file path, \code{"xifti"} object,
\code{"GIFTI"} file path, \code{"gifti"} object,
\code{"NIFTI"} file path, \code{"nifti"} object,
\code{"RDS"} file path, or \code{"data"}. The second element indicates
the sub-format if relevant; i.e. the type of CIFTI or GIFTI file/object.
}
\description{
Vectorized version of \code{\link{infer_format_ifti}}. Expects all inputs
to have the same format.
}
\details{
Raises an error if the elements of \code{BOLD} do not share the same format.
}
