% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leverage.R
\name{leverage}
\alias{leverage}
\title{Leverage}
\usage{
leverage(Comps, are_norm = FALSE, median_cutoff = NULL)
}
\arguments{
\item{Comps}{The \eqn{n} by \eqn{Q} PC score matrix/IC mixing matrix.}

\item{are_norm}{Assume the columns of \code{Comps} are orthogonal
and have 2-norms equal to 1? Speeds up the computation.}

\item{median_cutoff}{The outlier cutoff, in multiples of the median leverage.
Default: \code{NULL} (do not compute outliers).}
}
\value{
A list with entries \code{"meas"} (the leverage values),
\code{"cut"} (the leverage cutoff value) and
\code{"flag"} (logical vector indicating the outliers). If
\code{!is.null(median_cutoff)}, \code{"cut"} and \code{"flag"} are omitted.
}
\description{
Computes the leverage of each observation in the PC score (U) or
IC mixing (M) matrix for projection scrubbing. Can threshold to
flag potential outliers.
}
