% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fHMM_parameters.R
\name{fHMM_parameters}
\alias{fHMM_parameters}
\alias{print.fHMM_parameters}
\title{Set and check model parameters}
\usage{
fHMM_parameters(
  controls = list(),
  hierarchy = FALSE,
  states = if (!hierarchy) 2 else c(2, 2),
  sdds = if (!hierarchy) "normal" else c("normal", "normal"),
  Gamma = NULL,
  mu = NULL,
  sigma = NULL,
  df = NULL,
  Gamma_star = NULL,
  mu_star = NULL,
  sigma_star = NULL,
  df_star = NULL,
  scale_par = c(1, 1),
  seed = NULL,
  check_controls = TRUE
)

\method{print}{fHMM_parameters}(x, ...)
}
\arguments{
\item{controls}{Either a \code{list} or an object of class \code{fHMM_controls}.

The \code{list} can contain the following elements, which are described
in more detail below:
\itemize{
\item \code{hierarchy}, defines an hierarchical HMM,
\item \code{states}, defines the number of states,
\item \code{sdds}, defines the state-dependent distributions,
\item \code{horizon}, defines the time horizon,
\item \code{period}, defines a flexible, periodic fine-scale time horizon,
\item \code{data}, a \code{list} of controls that define the data,
\item \code{fit}, a \code{list} of controls that define the model fitting
}
Either none, all, or selected elements can be specified.

Unspecified parameters are set to their default values, see below.

Specifications in \code{controls} override individual specifications.}

\item{hierarchy}{A \code{logical}, set to \code{TRUE} for an hierarchical HMM.

If \code{hierarchy = TRUE}, some of the other controls must be specified for
the coarse-scale and the fine-scale layer.

By default, \code{hierarchy = FALSE}.}

\item{states}{An \code{integer}, the number of states of the underlying Markov chain.

If \code{hierarchy = TRUE}, \code{states} must be a \code{vector} of length
2. The first entry corresponds to the coarse-scale layer, while the second
entry corresponds to the fine-scale layer.

By default, \code{states = 2} if \code{hierarchy = FALSE} and
\code{states = c(2, 2)} if \code{hierarchy = TRUE}.}

\item{sdds}{A \code{character}, specifying the state-dependent distribution. One of
\itemize{
\item \code{"normal"} (the normal distribution),
\item \code{"lognormal"} (the log-normal distribution),
\item \code{"t"} (the t-distribution),
\item \code{"gamma"} (the gamma distribution),
\item \code{"poisson"} (the Poisson distribution).
}

The distribution parameters, i.e. the
\itemize{
\item mean \code{mu},
\item standard deviation \code{sigma} (not for the Poisson distribution),
\item degrees of freedom \code{df} (only for the t-distribution),
}
can be fixed via, e.g., \code{"t(df = 1)"} or
\code{"gamma(mu = 0, sigma = 1)"}.
To fix different values of a parameter for different states, separate by
"|", e.g. \code{"poisson(mu = 1|2|3)"}.

If \code{hierarchy = TRUE}, \code{sdds} must be a \code{vector} of length 2.
The first entry corresponds to the coarse-scale layer, while the second entry
corresponds to the fine-scale layer.

By default, \code{sdds = "normal"} if \code{hierarchy = FALSE} and
\code{sdds = c("normal", "normal")} if \code{hierarchy = TRUE}.}

\item{Gamma, Gamma_star}{A transition probability \code{matrix}.

It should have dimension \code{states[1]}.

\code{Gamma_star} is a \code{list} of fine-scale transition probability
matrices. The \code{list} must be of length \code{states[1]}.
Each transition probability matrix must be of dimension \code{states[2]}.}

\item{mu, mu_star}{A \code{numeric} vector of expected values for the state-dependent
distribution in the different states.

For the gamma- or Poisson-distribution, \code{mu} must be positive.

It should have length \code{states[1]}.

\code{mu_star} is a \code{list} of \code{vectors} with fine-scale
expectations. The \code{list} must be of length \code{states[1]}.
Each \code{vector} must be of length \code{states[2]}.}

\item{sigma, sigma_star}{A positive \code{numeric} vector of standard deviations for the
state-dependent distribution in the different states.

It should have length \code{states[1]}.

\code{sigma_star} is a \code{list} of \code{vectors} with fine-scale
standard deviations. The \code{list} must be of length \code{states[1]}.
Each vector must be of length \code{states[2]}.}

\item{df, df_star}{A positive \code{numeric} vector of degrees of freedom for the
state-dependent distribution in the different states.

It should have length \code{states[1]}.

Only relevant in case of a state-dependent t-distribution.

\code{df_star} is a \code{list} of \code{vectors} with fine-scale
degrees of freedom. The \code{list} must be of length \code{states[1]}.
Each vector must be of length \code{states[2]}.
Only relevant in case of a fine-scale state-dependent t-distribution.}

\item{scale_par}{A positive \code{numeric} vector of length two, containing scales for sampled
expectations and standard deviations.

The first entry is the scale for
\code{mu} and \code{sigma}, the second entry is the scale for
\code{mu_star} and \code{sigma_star} (if any).}

\item{seed}{Sets a seed for the sampling of parameters.}

\item{check_controls}{Either \code{TRUE} to check the defined controls or \code{FALSE} to not check
them (which saves computation time), else.}

\item{x}{An object of class \code{fHMM_parameters}.}

\item{...}{Currently not used.}
}
\value{
An object of class \code{fHMM_parameters}.
}
\description{
This function sets and checks model parameters.
Unspecified parameters are sampled.
}
\details{
See the \href{https://loelschlaeger.de/fHMM/articles/}{vignette on the model definition}
for more details.
}
\examples{
parameters <- fHMM_parameters(states = 2, sdds = "normal")
parameters$Gamma
}
