% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data_brownian.R
\name{generate_brownian_bridge}
\alias{generate_brownian_bridge}
\title{Generate a Brownian Bridge Process}
\usage{
generate_brownian_bridge(N, v = 30, sd = 1)
}
\arguments{
\item{N}{Numeric. The number of observations for the generated data.}

\item{v}{Numeric (vector). Discretization points of the curves.This can be
the evaluated points or the number of evenly spaced points on [0,1].
By default it is evenly spaced on [0,1] with 30 points.}

\item{sd}{Numeric. Standard deviation of the Brownian Motion process.
The default is \code{1}.}
}
\value{
Functional time series (dfts) object.
}
\description{
Generate a functional time series from an iid Brownian Bridge process.
If \eqn{W(t)} is a Wiener process, the Brownian Bridge is
defined as \eqn{W(t) - tW(1)}. Each functional observation is discretized on
the points indicated in \code{v}.
}
\examples{
bbridge <- generate_brownian_bridge(N=100, v=c(0,0.2,0.6,1,1.3), sd=2)
bbridge <- generate_brownian_bridge(N=100, v=10, sd=1)
}
